// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class FeatureWindow : IUtf8JsonSerializable, IJsonModel<FeatureWindow>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FeatureWindow>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FeatureWindow>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureWindow>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FeatureWindow)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FeatureWindowStart))
            {
                if (FeatureWindowStart != null)
                {
                    writer.WritePropertyName("featureWindowStart"u8);
                    writer.WriteStringValue(FeatureWindowStart.Value, "O");
                }
                else
                {
                    writer.WriteNull("featureWindowStart");
                }
            }
            if (Optional.IsDefined(FeatureWindowEnd))
            {
                if (FeatureWindowEnd != null)
                {
                    writer.WritePropertyName("featureWindowEnd"u8);
                    writer.WriteStringValue(FeatureWindowEnd.Value, "O");
                }
                else
                {
                    writer.WriteNull("featureWindowEnd");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FeatureWindow IJsonModel<FeatureWindow>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureWindow>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FeatureWindow)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFeatureWindow(document.RootElement, options);
        }

        internal static FeatureWindow DeserializeFeatureWindow(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? featureWindowStart = default;
            DateTimeOffset? featureWindowEnd = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("featureWindowStart"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        featureWindowStart = null;
                        continue;
                    }
                    featureWindowStart = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("featureWindowEnd"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        featureWindowEnd = null;
                        continue;
                    }
                    featureWindowEnd = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FeatureWindow(featureWindowStart, featureWindowEnd, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FeatureWindow>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureWindow>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FeatureWindow)} does not support writing '{options.Format}' format.");
            }
        }

        FeatureWindow IPersistableModel<FeatureWindow>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureWindow>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFeatureWindow(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FeatureWindow)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FeatureWindow>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
