// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class FeatureStoreSettings : IUtf8JsonSerializable, IJsonModel<FeatureStoreSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FeatureStoreSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FeatureStoreSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureStoreSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FeatureStoreSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ComputeRuntime))
            {
                writer.WritePropertyName("computeRuntime"u8);
                writer.WriteObjectValue(ComputeRuntime, options);
            }
            if (Optional.IsDefined(OfflineStoreConnectionName))
            {
                writer.WritePropertyName("offlineStoreConnectionName"u8);
                writer.WriteStringValue(OfflineStoreConnectionName);
            }
            if (Optional.IsDefined(OnlineStoreConnectionName))
            {
                writer.WritePropertyName("onlineStoreConnectionName"u8);
                writer.WriteStringValue(OnlineStoreConnectionName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FeatureStoreSettings IJsonModel<FeatureStoreSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureStoreSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FeatureStoreSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFeatureStoreSettings(document.RootElement, options);
        }

        internal static FeatureStoreSettings DeserializeFeatureStoreSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ComputeRuntimeDto computeRuntime = default;
            string offlineStoreConnectionName = default;
            string onlineStoreConnectionName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("computeRuntime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    computeRuntime = ComputeRuntimeDto.DeserializeComputeRuntimeDto(property.Value, options);
                    continue;
                }
                if (property.NameEquals("offlineStoreConnectionName"u8))
                {
                    offlineStoreConnectionName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("onlineStoreConnectionName"u8))
                {
                    onlineStoreConnectionName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FeatureStoreSettings(computeRuntime, offlineStoreConnectionName, onlineStoreConnectionName, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("SparkRuntimeVersion", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  computeRuntime: ");
                builder.AppendLine("{");
                builder.Append("    sparkRuntimeVersion: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(ComputeRuntime))
                {
                    builder.Append("  computeRuntime: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ComputeRuntime, options, 2, false, "  computeRuntime: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OfflineStoreConnectionName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  offlineStoreConnectionName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OfflineStoreConnectionName))
                {
                    builder.Append("  offlineStoreConnectionName: ");
                    if (OfflineStoreConnectionName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OfflineStoreConnectionName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OfflineStoreConnectionName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OnlineStoreConnectionName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  onlineStoreConnectionName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OnlineStoreConnectionName))
                {
                    builder.Append("  onlineStoreConnectionName: ");
                    if (OnlineStoreConnectionName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OnlineStoreConnectionName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OnlineStoreConnectionName}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<FeatureStoreSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureStoreSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(FeatureStoreSettings)} does not support writing '{options.Format}' format.");
            }
        }

        FeatureStoreSettings IPersistableModel<FeatureStoreSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureStoreSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFeatureStoreSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FeatureStoreSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FeatureStoreSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
