// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The mode of operation for computing feature importance. </summary>
    public readonly partial struct FeatureImportanceMode : IEquatable<FeatureImportanceMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FeatureImportanceMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FeatureImportanceMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disables computing feature importance within a signal. </summary>
        public static FeatureImportanceMode Disabled { get; } = new FeatureImportanceMode(DisabledValue);
        /// <summary> Enables computing feature importance within a signal. </summary>
        public static FeatureImportanceMode Enabled { get; } = new FeatureImportanceMode(EnabledValue);
        /// <summary> Determines if two <see cref="FeatureImportanceMode"/> values are the same. </summary>
        public static bool operator ==(FeatureImportanceMode left, FeatureImportanceMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FeatureImportanceMode"/> values are not the same. </summary>
        public static bool operator !=(FeatureImportanceMode left, FeatureImportanceMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FeatureImportanceMode"/>. </summary>
        public static implicit operator FeatureImportanceMode(string value) => new FeatureImportanceMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FeatureImportanceMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FeatureImportanceMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
