// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The FeatureDataType. </summary>
    public readonly partial struct FeatureDataType : IEquatable<FeatureDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FeatureDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FeatureDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "String";
        private const string IntegerValue = "Integer";
        private const string LongValue = "Long";
        private const string FloatValue = "Float";
        private const string DoubleValue = "Double";
        private const string BinaryValue = "Binary";
        private const string DatetimeValue = "Datetime";
        private const string BooleanValue = "Boolean";

        /// <summary> String. </summary>
        public static FeatureDataType String { get; } = new FeatureDataType(StringValue);
        /// <summary> Integer. </summary>
        public static FeatureDataType Integer { get; } = new FeatureDataType(IntegerValue);
        /// <summary> Long. </summary>
        public static FeatureDataType Long { get; } = new FeatureDataType(LongValue);
        /// <summary> Float. </summary>
        public static FeatureDataType Float { get; } = new FeatureDataType(FloatValue);
        /// <summary> Double. </summary>
        public static FeatureDataType Double { get; } = new FeatureDataType(DoubleValue);
        /// <summary> Binary. </summary>
        public static FeatureDataType Binary { get; } = new FeatureDataType(BinaryValue);
        /// <summary> Datetime. </summary>
        public static FeatureDataType Datetime { get; } = new FeatureDataType(DatetimeValue);
        /// <summary> Boolean. </summary>
        public static FeatureDataType Boolean { get; } = new FeatureDataType(BooleanValue);
        /// <summary> Determines if two <see cref="FeatureDataType"/> values are the same. </summary>
        public static bool operator ==(FeatureDataType left, FeatureDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FeatureDataType"/> values are not the same. </summary>
        public static bool operator !=(FeatureDataType left, FeatureDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FeatureDataType"/>. </summary>
        public static implicit operator FeatureDataType(string value) => new FeatureDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FeatureDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FeatureDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
