// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The FeatureAttributionMetric. </summary>
    public readonly partial struct FeatureAttributionMetric : IEquatable<FeatureAttributionMetric>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FeatureAttributionMetric"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FeatureAttributionMetric(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NormalizedDiscountedCumulativeGainValue = "NormalizedDiscountedCumulativeGain";

        /// <summary> The Normalized Discounted Cumulative Gain metric. </summary>
        public static FeatureAttributionMetric NormalizedDiscountedCumulativeGain { get; } = new FeatureAttributionMetric(NormalizedDiscountedCumulativeGainValue);
        /// <summary> Determines if two <see cref="FeatureAttributionMetric"/> values are the same. </summary>
        public static bool operator ==(FeatureAttributionMetric left, FeatureAttributionMetric right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FeatureAttributionMetric"/> values are not the same. </summary>
        public static bool operator !=(FeatureAttributionMetric left, FeatureAttributionMetric right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FeatureAttributionMetric"/>. </summary>
        public static implicit operator FeatureAttributionMetric(string value) => new FeatureAttributionMetric(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FeatureAttributionMetric other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FeatureAttributionMetric other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
