// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class FeatureAttributionDriftMonitoringSignal : IUtf8JsonSerializable, IJsonModel<FeatureAttributionDriftMonitoringSignal>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FeatureAttributionDriftMonitoringSignal>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FeatureAttributionDriftMonitoringSignal>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureAttributionDriftMonitoringSignal>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FeatureAttributionDriftMonitoringSignal)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("metricThreshold"u8);
            writer.WriteObjectValue(MetricThreshold, options);
            writer.WritePropertyName("featureImportanceSettings"u8);
            writer.WriteObjectValue(FeatureImportanceSettings, options);
            writer.WritePropertyName("productionData"u8);
            writer.WriteStartArray();
            foreach (var item in ProductionData)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("referenceData"u8);
            writer.WriteObjectValue(ReferenceData, options);
            if (Optional.IsCollectionDefined(FeatureDataTypeOverride))
            {
                if (FeatureDataTypeOverride != null)
                {
                    writer.WritePropertyName("featureDataTypeOverride"u8);
                    writer.WriteStartObject();
                    foreach (var item in FeatureDataTypeOverride)
                    {
                        writer.WritePropertyName(item.Key);
                        writer.WriteStringValue(item.Value.ToString());
                    }
                    writer.WriteEndObject();
                }
                else
                {
                    writer.WriteNull("featureDataTypeOverride");
                }
            }
        }

        FeatureAttributionDriftMonitoringSignal IJsonModel<FeatureAttributionDriftMonitoringSignal>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureAttributionDriftMonitoringSignal>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FeatureAttributionDriftMonitoringSignal)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFeatureAttributionDriftMonitoringSignal(document.RootElement, options);
        }

        internal static FeatureAttributionDriftMonitoringSignal DeserializeFeatureAttributionDriftMonitoringSignal(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FeatureAttributionMetricThreshold metricThreshold = default;
            FeatureImportanceSettings featureImportanceSettings = default;
            IList<MonitoringInputDataBase> productionData = default;
            MonitoringInputDataBase referenceData = default;
            IDictionary<string, MonitoringFeatureDataType> featureDataTypeOverride = default;
            MonitoringSignalType signalType = default;
            IList<MonitoringNotificationType> notificationTypes = default;
            IDictionary<string, string> properties = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("metricThreshold"u8))
                {
                    metricThreshold = FeatureAttributionMetricThreshold.DeserializeFeatureAttributionMetricThreshold(property.Value, options);
                    continue;
                }
                if (property.NameEquals("featureImportanceSettings"u8))
                {
                    featureImportanceSettings = FeatureImportanceSettings.DeserializeFeatureImportanceSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("productionData"u8))
                {
                    List<MonitoringInputDataBase> array = new List<MonitoringInputDataBase>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MonitoringInputDataBase.DeserializeMonitoringInputDataBase(item, options));
                    }
                    productionData = array;
                    continue;
                }
                if (property.NameEquals("referenceData"u8))
                {
                    referenceData = MonitoringInputDataBase.DeserializeMonitoringInputDataBase(property.Value, options);
                    continue;
                }
                if (property.NameEquals("featureDataTypeOverride"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        featureDataTypeOverride = null;
                        continue;
                    }
                    Dictionary<string, MonitoringFeatureDataType> dictionary = new Dictionary<string, MonitoringFeatureDataType>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, new MonitoringFeatureDataType(property0.Value.GetString()));
                    }
                    featureDataTypeOverride = dictionary;
                    continue;
                }
                if (property.NameEquals("signalType"u8))
                {
                    signalType = new MonitoringSignalType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("notificationTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        notificationTypes = null;
                        continue;
                    }
                    List<MonitoringNotificationType> array = new List<MonitoringNotificationType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new MonitoringNotificationType(item.GetString()));
                    }
                    notificationTypes = array;
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        properties = null;
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    properties = dictionary;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FeatureAttributionDriftMonitoringSignal(
                signalType,
                notificationTypes ?? new ChangeTrackingList<MonitoringNotificationType>(),
                properties ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData,
                metricThreshold,
                featureImportanceSettings,
                productionData,
                referenceData,
                featureDataTypeOverride ?? new ChangeTrackingDictionary<string, MonitoringFeatureDataType>());
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MetricThreshold), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  metricThreshold: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MetricThreshold))
                {
                    builder.Append("  metricThreshold: ");
                    BicepSerializationHelpers.AppendChildObject(builder, MetricThreshold, options, 2, false, "  metricThreshold: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FeatureImportanceSettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  featureImportanceSettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FeatureImportanceSettings))
                {
                    builder.Append("  featureImportanceSettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, FeatureImportanceSettings, options, 2, false, "  featureImportanceSettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProductionData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  productionData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ProductionData))
                {
                    if (ProductionData.Any())
                    {
                        builder.Append("  productionData: ");
                        builder.AppendLine("[");
                        foreach (var item in ProductionData)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  productionData: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ReferenceData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  referenceData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ReferenceData))
                {
                    builder.Append("  referenceData: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ReferenceData, options, 2, false, "  referenceData: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FeatureDataTypeOverride), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  featureDataTypeOverride: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(FeatureDataTypeOverride))
                {
                    if (FeatureDataTypeOverride.Any())
                    {
                        builder.Append("  featureDataTypeOverride: ");
                        builder.AppendLine("{");
                        foreach (var item in FeatureDataTypeOverride)
                        {
                            builder.Append($"    '{item.Key}': ");
                            builder.AppendLine($"'{item.Value.ToString()}'");
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SignalType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  signalType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  signalType: ");
                builder.AppendLine($"'{SignalType.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NotificationTypes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  notificationTypes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(NotificationTypes))
                {
                    if (NotificationTypes.Any())
                    {
                        builder.Append("  notificationTypes: ");
                        builder.AppendLine("[");
                        foreach (var item in NotificationTypes)
                        {
                            builder.AppendLine($"    '{item.ToString()}'");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Properties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  properties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Properties))
                {
                    if (Properties.Any())
                    {
                        builder.Append("  properties: ");
                        builder.AppendLine("{");
                        foreach (var item in Properties)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<FeatureAttributionDriftMonitoringSignal>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureAttributionDriftMonitoringSignal>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(FeatureAttributionDriftMonitoringSignal)} does not support writing '{options.Format}' format.");
            }
        }

        FeatureAttributionDriftMonitoringSignal IPersistableModel<FeatureAttributionDriftMonitoringSignal>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FeatureAttributionDriftMonitoringSignal>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFeatureAttributionDriftMonitoringSignal(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FeatureAttributionDriftMonitoringSignal)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FeatureAttributionDriftMonitoringSignal>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
