// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Connection status of the service consumer with the service provider. </summary>
    public readonly partial struct EndpointServiceConnectionStatus : IEquatable<EndpointServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EndpointServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EndpointServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApprovedValue = "Approved";
        private const string PendingValue = "Pending";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Approved. </summary>
        public static EndpointServiceConnectionStatus Approved { get; } = new EndpointServiceConnectionStatus(ApprovedValue);
        /// <summary> Pending. </summary>
        public static EndpointServiceConnectionStatus Pending { get; } = new EndpointServiceConnectionStatus(PendingValue);
        /// <summary> Rejected. </summary>
        public static EndpointServiceConnectionStatus Rejected { get; } = new EndpointServiceConnectionStatus(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static EndpointServiceConnectionStatus Disconnected { get; } = new EndpointServiceConnectionStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="EndpointServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(EndpointServiceConnectionStatus left, EndpointServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EndpointServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(EndpointServiceConnectionStatus left, EndpointServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EndpointServiceConnectionStatus"/>. </summary>
        public static implicit operator EndpointServiceConnectionStatus(string value) => new EndpointServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EndpointServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EndpointServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
