// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine the email notification type. </summary>
    public readonly partial struct EmailNotificationEnableType : IEquatable<EmailNotificationEnableType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EmailNotificationEnableType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EmailNotificationEnableType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JobCompletedValue = "JobCompleted";
        private const string JobFailedValue = "JobFailed";
        private const string JobCancelledValue = "JobCancelled";

        /// <summary> JobCompleted. </summary>
        public static EmailNotificationEnableType JobCompleted { get; } = new EmailNotificationEnableType(JobCompletedValue);
        /// <summary> JobFailed. </summary>
        public static EmailNotificationEnableType JobFailed { get; } = new EmailNotificationEnableType(JobFailedValue);
        /// <summary> JobCancelled. </summary>
        public static EmailNotificationEnableType JobCancelled { get; } = new EmailNotificationEnableType(JobCancelledValue);
        /// <summary> Determines if two <see cref="EmailNotificationEnableType"/> values are the same. </summary>
        public static bool operator ==(EmailNotificationEnableType left, EmailNotificationEnableType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EmailNotificationEnableType"/> values are not the same. </summary>
        public static bool operator !=(EmailNotificationEnableType left, EmailNotificationEnableType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EmailNotificationEnableType"/>. </summary>
        public static implicit operator EmailNotificationEnableType(string value) => new EmailNotificationEnableType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EmailNotificationEnableType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EmailNotificationEnableType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
