// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Docker container configuration. </summary>
    public partial class DockerSetting
    {
        /// <summary> Initializes a new instance of <see cref="DockerSetting"/>. </summary>
        public DockerSetting()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="DockerSetting"/>. </summary>
        /// <param name="privileged"> Indicate whether container shall run in privileged or non-privileged mode. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal DockerSetting(bool? privileged, IDictionary<string, BinaryData> additionalProperties)
        {
            Privileged = privileged;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Indicate whether container shall run in privileged or non-privileged mode. </summary>
        [WirePath("privileged")]
        public bool? Privileged { get; set; }
        /// <summary>
        /// Additional Properties
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("AdditionalProperties")]
        public IDictionary<string, BinaryData> AdditionalProperties { get; }
    }
}
