// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine the DataReference credentials type. </summary>
    internal readonly partial struct DataReferenceCredentialType : IEquatable<DataReferenceCredentialType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataReferenceCredentialType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataReferenceCredentialType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SasValue = "SAS";
        private const string DockerCredentialsValue = "DockerCredentials";
        private const string ManagedIdentityValue = "ManagedIdentity";
        private const string NoCredentialsValue = "NoCredentials";

        /// <summary> SAS. </summary>
        public static DataReferenceCredentialType Sas { get; } = new DataReferenceCredentialType(SasValue);
        /// <summary> DockerCredentials. </summary>
        public static DataReferenceCredentialType DockerCredentials { get; } = new DataReferenceCredentialType(DockerCredentialsValue);
        /// <summary> ManagedIdentity. </summary>
        public static DataReferenceCredentialType ManagedIdentity { get; } = new DataReferenceCredentialType(ManagedIdentityValue);
        /// <summary> NoCredentials. </summary>
        public static DataReferenceCredentialType NoCredentials { get; } = new DataReferenceCredentialType(NoCredentialsValue);
        /// <summary> Determines if two <see cref="DataReferenceCredentialType"/> values are the same. </summary>
        public static bool operator ==(DataReferenceCredentialType left, DataReferenceCredentialType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataReferenceCredentialType"/> values are not the same. </summary>
        public static bool operator !=(DataReferenceCredentialType left, DataReferenceCredentialType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataReferenceCredentialType"/>. </summary>
        public static implicit operator DataReferenceCredentialType(string value) => new DataReferenceCredentialType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataReferenceCredentialType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataReferenceCredentialType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
