// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The DataQualityMonitoringSignal. </summary>
    public partial class DataQualityMonitoringSignal : MonitoringSignalBase
    {
        /// <summary> Initializes a new instance of <see cref="DataQualityMonitoringSignal"/>. </summary>
        /// <param name="metricThresholds">
        /// [Required] A list of metrics to calculate and their associated thresholds.
        /// Please note <see cref="DataQualityMetricThresholdBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="CategoricalDataQualityMetricThreshold"/> and <see cref="NumericalDataQualityMetricThreshold"/>.
        /// </param>
        /// <param name="productionData">
        /// [Required] The data produced by the production service which drift will be calculated for.
        /// Please note <see cref="MonitoringInputDataBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FixedInputData"/>, <see cref="RollingInputData"/> and <see cref="StaticInputData"/>.
        /// </param>
        /// <param name="referenceData">
        /// [Required] The data to calculate drift against.
        /// Please note <see cref="MonitoringInputDataBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FixedInputData"/>, <see cref="RollingInputData"/> and <see cref="StaticInputData"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="metricThresholds"/>, <paramref name="productionData"/> or <paramref name="referenceData"/> is null. </exception>
        public DataQualityMonitoringSignal(IEnumerable<DataQualityMetricThresholdBase> metricThresholds, MonitoringInputDataBase productionData, MonitoringInputDataBase referenceData)
        {
            Argument.AssertNotNull(metricThresholds, nameof(metricThresholds));
            Argument.AssertNotNull(productionData, nameof(productionData));
            Argument.AssertNotNull(referenceData, nameof(referenceData));

            MetricThresholds = metricThresholds.ToList();
            ProductionData = productionData;
            ReferenceData = referenceData;
            FeatureDataTypeOverride = new ChangeTrackingDictionary<string, MonitoringFeatureDataType>();
            SignalType = MonitoringSignalType.DataQuality;
        }

        /// <summary> Initializes a new instance of <see cref="DataQualityMonitoringSignal"/>. </summary>
        /// <param name="signalType"> [Required] Specifies the type of signal to monitor. </param>
        /// <param name="notificationTypes"> The current notification mode for this signal. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="features">
        /// The features to calculate drift over.
        /// Please note <see cref="MonitoringFeatureFilterBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningAllFeatures"/>, <see cref="FeatureSubset"/> and <see cref="TopNFeaturesByAttribution"/>.
        /// </param>
        /// <param name="featureImportanceSettings"> The settings for computing feature importance. </param>
        /// <param name="metricThresholds">
        /// [Required] A list of metrics to calculate and their associated thresholds.
        /// Please note <see cref="DataQualityMetricThresholdBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="CategoricalDataQualityMetricThreshold"/> and <see cref="NumericalDataQualityMetricThreshold"/>.
        /// </param>
        /// <param name="productionData">
        /// [Required] The data produced by the production service which drift will be calculated for.
        /// Please note <see cref="MonitoringInputDataBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FixedInputData"/>, <see cref="RollingInputData"/> and <see cref="StaticInputData"/>.
        /// </param>
        /// <param name="referenceData">
        /// [Required] The data to calculate drift against.
        /// Please note <see cref="MonitoringInputDataBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FixedInputData"/>, <see cref="RollingInputData"/> and <see cref="StaticInputData"/>.
        /// </param>
        /// <param name="featureDataTypeOverride"> A dictionary that maps feature names to their respective data types. </param>
        internal DataQualityMonitoringSignal(MonitoringSignalType signalType, IList<MonitoringNotificationType> notificationTypes, IDictionary<string, string> properties, IDictionary<string, BinaryData> serializedAdditionalRawData, MonitoringFeatureFilterBase features, FeatureImportanceSettings featureImportanceSettings, IList<DataQualityMetricThresholdBase> metricThresholds, MonitoringInputDataBase productionData, MonitoringInputDataBase referenceData, IDictionary<string, MonitoringFeatureDataType> featureDataTypeOverride) : base(signalType, notificationTypes, properties, serializedAdditionalRawData)
        {
            Features = features;
            FeatureImportanceSettings = featureImportanceSettings;
            MetricThresholds = metricThresholds;
            ProductionData = productionData;
            ReferenceData = referenceData;
            FeatureDataTypeOverride = featureDataTypeOverride;
            SignalType = signalType;
        }

        /// <summary> Initializes a new instance of <see cref="DataQualityMonitoringSignal"/> for deserialization. </summary>
        internal DataQualityMonitoringSignal()
        {
        }

        /// <summary>
        /// The features to calculate drift over.
        /// Please note <see cref="MonitoringFeatureFilterBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningAllFeatures"/>, <see cref="FeatureSubset"/> and <see cref="TopNFeaturesByAttribution"/>.
        /// </summary>
        [WirePath("features")]
        public MonitoringFeatureFilterBase Features { get; set; }
        /// <summary> The settings for computing feature importance. </summary>
        [WirePath("featureImportanceSettings")]
        public FeatureImportanceSettings FeatureImportanceSettings { get; set; }
        /// <summary>
        /// [Required] A list of metrics to calculate and their associated thresholds.
        /// Please note <see cref="DataQualityMetricThresholdBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="CategoricalDataQualityMetricThreshold"/> and <see cref="NumericalDataQualityMetricThreshold"/>.
        /// </summary>
        [WirePath("metricThresholds")]
        public IList<DataQualityMetricThresholdBase> MetricThresholds { get; }
        /// <summary>
        /// [Required] The data produced by the production service which drift will be calculated for.
        /// Please note <see cref="MonitoringInputDataBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FixedInputData"/>, <see cref="RollingInputData"/> and <see cref="StaticInputData"/>.
        /// </summary>
        [WirePath("productionData")]
        public MonitoringInputDataBase ProductionData { get; set; }
        /// <summary>
        /// [Required] The data to calculate drift against.
        /// Please note <see cref="MonitoringInputDataBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FixedInputData"/>, <see cref="RollingInputData"/> and <see cref="StaticInputData"/>.
        /// </summary>
        [WirePath("referenceData")]
        public MonitoringInputDataBase ReferenceData { get; set; }
        /// <summary> A dictionary that maps feature names to their respective data types. </summary>
        [WirePath("featureDataTypeOverride")]
        public IDictionary<string, MonitoringFeatureDataType> FeatureDataTypeOverride { get; set; }
    }
}
