// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The CustomTargetLags. </summary>
    public partial class CustomTargetLags : TargetLags
    {
        /// <summary> Initializes a new instance of <see cref="CustomTargetLags"/>. </summary>
        /// <param name="values"> [Required] Set target lags values. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="values"/> is null. </exception>
        public CustomTargetLags(IEnumerable<int> values)
        {
            Argument.AssertNotNull(values, nameof(values));

            Values = values.ToList();
            Mode = TargetLagsMode.Custom;
        }

        /// <summary> Initializes a new instance of <see cref="CustomTargetLags"/>. </summary>
        /// <param name="mode"> [Required] Set target lags mode - Auto/Custom. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="values"> [Required] Set target lags values. </param>
        internal CustomTargetLags(TargetLagsMode mode, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<int> values) : base(mode, serializedAdditionalRawData)
        {
            Values = values;
            Mode = mode;
        }

        /// <summary> Initializes a new instance of <see cref="CustomTargetLags"/> for deserialization. </summary>
        internal CustomTargetLags()
        {
        }

        /// <summary> [Required] Set target lags values. </summary>
        [WirePath("values")]
        public IList<int> Values { get; }
    }
}
