// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The CustomMetricThreshold. </summary>
    public partial class CustomMetricThreshold
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CustomMetricThreshold"/>. </summary>
        /// <param name="metric"> [Required] The user-defined metric to calculate. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="metric"/> is null. </exception>
        public CustomMetricThreshold(string metric)
        {
            Argument.AssertNotNull(metric, nameof(metric));

            Metric = metric;
        }

        /// <summary> Initializes a new instance of <see cref="CustomMetricThreshold"/>. </summary>
        /// <param name="threshold"> The threshold value. If null, a default value will be set depending on the selected metric. </param>
        /// <param name="metric"> [Required] The user-defined metric to calculate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CustomMetricThreshold(MonitoringThreshold threshold, string metric, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Threshold = threshold;
            Metric = metric;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CustomMetricThreshold"/> for deserialization. </summary>
        internal CustomMetricThreshold()
        {
        }

        /// <summary> The threshold value. If null, a default value will be set depending on the selected metric. </summary>
        internal MonitoringThreshold Threshold { get; set; }
        /// <summary> The threshold value. If null, the set default is dependent on the metric type. </summary>
        [WirePath("threshold.value")]
        public double? ThresholdValue
        {
            get => Threshold is null ? default : Threshold.Value;
            set
            {
                if (Threshold is null)
                    Threshold = new MonitoringThreshold();
                Threshold.Value = value;
            }
        }

        /// <summary> [Required] The user-defined metric to calculate. </summary>
        [WirePath("metric")]
        public string Metric { get; set; }
    }
}
