// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine the datastore credentials type. </summary>
    internal readonly partial struct CredentialsType : IEquatable<CredentialsType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CredentialsType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CredentialsType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AccountKeyValue = "AccountKey";
        private const string CertificateValue = "Certificate";
        private const string NoneValue = "None";
        private const string SasValue = "Sas";
        private const string ServicePrincipalValue = "ServicePrincipal";

        /// <summary> AccountKey. </summary>
        public static CredentialsType AccountKey { get; } = new CredentialsType(AccountKeyValue);
        /// <summary> Certificate. </summary>
        public static CredentialsType Certificate { get; } = new CredentialsType(CertificateValue);
        /// <summary> None. </summary>
        public static CredentialsType None { get; } = new CredentialsType(NoneValue);
        /// <summary> Sas. </summary>
        public static CredentialsType Sas { get; } = new CredentialsType(SasValue);
        /// <summary> ServicePrincipal. </summary>
        public static CredentialsType ServicePrincipal { get; } = new CredentialsType(ServicePrincipalValue);
        /// <summary> Determines if two <see cref="CredentialsType"/> values are the same. </summary>
        public static bool operator ==(CredentialsType left, CredentialsType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CredentialsType"/> values are not the same. </summary>
        public static bool operator !=(CredentialsType left, CredentialsType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CredentialsType"/>. </summary>
        public static implicit operator CredentialsType(string value) => new CredentialsType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CredentialsType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CredentialsType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
