// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The CreateMonitorAction. </summary>
    public partial class CreateMonitorAction : MachineLearningScheduleAction
    {
        /// <summary> Initializes a new instance of <see cref="CreateMonitorAction"/>. </summary>
        /// <param name="monitorDefinition"> [Required] Defines the monitor. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="monitorDefinition"/> is null. </exception>
        public CreateMonitorAction(MonitorDefinition monitorDefinition)
        {
            Argument.AssertNotNull(monitorDefinition, nameof(monitorDefinition));

            MonitorDefinition = monitorDefinition;
            ActionType = ScheduleActionType.CreateMonitor;
        }

        /// <summary> Initializes a new instance of <see cref="CreateMonitorAction"/>. </summary>
        /// <param name="actionType"> [Required] Specifies the action type of the schedule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="monitorDefinition"> [Required] Defines the monitor. </param>
        internal CreateMonitorAction(ScheduleActionType actionType, IDictionary<string, BinaryData> serializedAdditionalRawData, MonitorDefinition monitorDefinition) : base(actionType, serializedAdditionalRawData)
        {
            MonitorDefinition = monitorDefinition;
            ActionType = actionType;
        }

        /// <summary> Initializes a new instance of <see cref="CreateMonitorAction"/> for deserialization. </summary>
        internal CreateMonitorAction()
        {
        }

        /// <summary> [Required] Defines the monitor. </summary>
        [WirePath("monitorDefinition")]
        public MonitorDefinition MonitorDefinition { get; set; }
    }
}
