// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Specifies the status of content safety. </summary>
    public readonly partial struct ContentSafetyStatus : IEquatable<ContentSafetyStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContentSafetyStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContentSafetyStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static ContentSafetyStatus Enabled { get; } = new ContentSafetyStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static ContentSafetyStatus Disabled { get; } = new ContentSafetyStatus(DisabledValue);
        /// <summary> Determines if two <see cref="ContentSafetyStatus"/> values are the same. </summary>
        public static bool operator ==(ContentSafetyStatus left, ContentSafetyStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContentSafetyStatus"/> values are not the same. </summary>
        public static bool operator !=(ContentSafetyStatus left, ContentSafetyStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContentSafetyStatus"/>. </summary>
        public static implicit operator ContentSafetyStatus(string value) => new ContentSafetyStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContentSafetyStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContentSafetyStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
