// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Describes the endpoint configuration for the container. </summary>
    public partial class ContainerEndpoint
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerEndpoint"/>. </summary>
        public ContainerEndpoint()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerEndpoint"/>. </summary>
        /// <param name="protocol"> Protocol over which communication will happen over this endpoint. </param>
        /// <param name="name"> Name of the Endpoint. </param>
        /// <param name="target"> Application port inside the container. </param>
        /// <param name="published"> Port over which the application is exposed from container. </param>
        /// <param name="hostIP"> Host IP over which the application is exposed from the container. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerEndpoint(ContainerCommunicationProtocol? protocol, string name, int? target, int? published, string hostIP, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Protocol = protocol;
            Name = name;
            Target = target;
            Published = published;
            HostIP = hostIP;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Protocol over which communication will happen over this endpoint. </summary>
        [WirePath("protocol")]
        public ContainerCommunicationProtocol? Protocol { get; set; }
        /// <summary> Name of the Endpoint. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Application port inside the container. </summary>
        [WirePath("target")]
        public int? Target { get; set; }
        /// <summary> Port over which the application is exposed from container. </summary>
        [WirePath("published")]
        public int? Published { get; set; }
        /// <summary> Host IP over which the application is exposed from the container. </summary>
        [WirePath("hostIp")]
        public string HostIP { get; set; }
    }
}
