// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Protocol over which communication will happen over this endpoint. </summary>
    public readonly partial struct ContainerCommunicationProtocol : IEquatable<ContainerCommunicationProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerCommunicationProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerCommunicationProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "tcp";
        private const string UdpValue = "udp";
        private const string HttpValue = "http";

        /// <summary> tcp. </summary>
        public static ContainerCommunicationProtocol Tcp { get; } = new ContainerCommunicationProtocol(TcpValue);
        /// <summary> udp. </summary>
        public static ContainerCommunicationProtocol Udp { get; } = new ContainerCommunicationProtocol(UdpValue);
        /// <summary> http. </summary>
        public static ContainerCommunicationProtocol Http { get; } = new ContainerCommunicationProtocol(HttpValue);
        /// <summary> Determines if two <see cref="ContainerCommunicationProtocol"/> values are the same. </summary>
        public static bool operator ==(ContainerCommunicationProtocol left, ContainerCommunicationProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerCommunicationProtocol"/> values are not the same. </summary>
        public static bool operator !=(ContainerCommunicationProtocol left, ContainerCommunicationProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerCommunicationProtocol"/>. </summary>
        public static implicit operator ContainerCommunicationProtocol(string value) => new ContainerCommunicationProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerCommunicationProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerCommunicationProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
