// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The type of compute. </summary>
    internal readonly partial struct ComputeType : IEquatable<ComputeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AksValue = "AKS";
        private const string KubernetesValue = "Kubernetes";
        private const string AmlComputeValue = "AmlCompute";
        private const string ComputeInstanceValue = "ComputeInstance";
        private const string DataFactoryValue = "DataFactory";
        private const string VirtualMachineValue = "VirtualMachine";
        private const string HDInsightValue = "HDInsight";
        private const string DatabricksValue = "Databricks";
        private const string DataLakeAnalyticsValue = "DataLakeAnalytics";
        private const string SynapseSparkValue = "SynapseSpark";

        /// <summary> AKS. </summary>
        public static ComputeType Aks { get; } = new ComputeType(AksValue);
        /// <summary> Kubernetes. </summary>
        public static ComputeType Kubernetes { get; } = new ComputeType(KubernetesValue);
        /// <summary> AmlCompute. </summary>
        public static ComputeType AmlCompute { get; } = new ComputeType(AmlComputeValue);
        /// <summary> ComputeInstance. </summary>
        public static ComputeType ComputeInstance { get; } = new ComputeType(ComputeInstanceValue);
        /// <summary> DataFactory. </summary>
        public static ComputeType DataFactory { get; } = new ComputeType(DataFactoryValue);
        /// <summary> VirtualMachine. </summary>
        public static ComputeType VirtualMachine { get; } = new ComputeType(VirtualMachineValue);
        /// <summary> HDInsight. </summary>
        public static ComputeType HDInsight { get; } = new ComputeType(HDInsightValue);
        /// <summary> Databricks. </summary>
        public static ComputeType Databricks { get; } = new ComputeType(DatabricksValue);
        /// <summary> DataLakeAnalytics. </summary>
        public static ComputeType DataLakeAnalytics { get; } = new ComputeType(DataLakeAnalyticsValue);
        /// <summary> SynapseSpark. </summary>
        public static ComputeType SynapseSpark { get; } = new ComputeType(SynapseSparkValue);
        /// <summary> Determines if two <see cref="ComputeType"/> values are the same. </summary>
        public static bool operator ==(ComputeType left, ComputeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeType"/> values are not the same. </summary>
        public static bool operator !=(ComputeType left, ComputeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeType"/>. </summary>
        public static implicit operator ComputeType(string value) => new ComputeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
