// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The workflow trigger cron for ComputeStartStop schedule type. </summary>
    public partial class ComputeStartStopCronSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeStartStopCronSchedule"/>. </summary>
        public ComputeStartStopCronSchedule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ComputeStartStopCronSchedule"/>. </summary>
        /// <param name="startTime"> The start time in yyyy-MM-ddTHH:mm:ss format. </param>
        /// <param name="timeZone">
        /// Specifies time zone in which the schedule runs.
        /// TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        /// </param>
        /// <param name="expression">
        /// [Required] Specifies cron expression of schedule.
        /// The expression should follow NCronTab format.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeStartStopCronSchedule(string startTime, string timeZone, string expression, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartTime = startTime;
            TimeZone = timeZone;
            Expression = expression;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The start time in yyyy-MM-ddTHH:mm:ss format. </summary>
        [WirePath("startTime")]
        public string StartTime { get; set; }
        /// <summary>
        /// Specifies time zone in which the schedule runs.
        /// TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        /// </summary>
        [WirePath("timeZone")]
        public string TimeZone { get; set; }
        /// <summary>
        /// [Required] Specifies cron expression of schedule.
        /// The expression should follow NCronTab format.
        /// </summary>
        [WirePath("expression")]
        public string Expression { get; set; }
    }
}
