// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Primary metrics for classification multilabel tasks. </summary>
    public readonly partial struct ClassificationMultilabelPrimaryMetric : IEquatable<ClassificationMultilabelPrimaryMetric>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClassificationMultilabelPrimaryMetric"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClassificationMultilabelPrimaryMetric(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AUCWeightedValue = "AUCWeighted";
        private const string AccuracyValue = "Accuracy";
        private const string NormMacroRecallValue = "NormMacroRecall";
        private const string AveragePrecisionScoreWeightedValue = "AveragePrecisionScoreWeighted";
        private const string PrecisionScoreWeightedValue = "PrecisionScoreWeighted";
        private const string IOUValue = "IOU";

        /// <summary>
        /// AUC is the Area under the curve.
        /// This metric represents arithmetic mean of the score for each class,
        /// weighted by the number of true instances in each class.
        /// </summary>
        public static ClassificationMultilabelPrimaryMetric AUCWeighted { get; } = new ClassificationMultilabelPrimaryMetric(AUCWeightedValue);
        /// <summary> Accuracy is the ratio of predictions that exactly match the true class labels. </summary>
        public static ClassificationMultilabelPrimaryMetric Accuracy { get; } = new ClassificationMultilabelPrimaryMetric(AccuracyValue);
        /// <summary>
        /// Normalized macro recall is recall macro-averaged and normalized, so that random
        /// performance has a score of 0, and perfect performance has a score of 1.
        /// </summary>
        public static ClassificationMultilabelPrimaryMetric NormMacroRecall { get; } = new ClassificationMultilabelPrimaryMetric(NormMacroRecallValue);
        /// <summary>
        /// The arithmetic mean of the average precision score for each class, weighted by
        /// the number of true instances in each class.
        /// </summary>
        public static ClassificationMultilabelPrimaryMetric AveragePrecisionScoreWeighted { get; } = new ClassificationMultilabelPrimaryMetric(AveragePrecisionScoreWeightedValue);
        /// <summary> The arithmetic mean of precision for each class, weighted by number of true instances in each class. </summary>
        public static ClassificationMultilabelPrimaryMetric PrecisionScoreWeighted { get; } = new ClassificationMultilabelPrimaryMetric(PrecisionScoreWeightedValue);
        /// <summary> Intersection Over Union. Intersection of predictions divided by union of predictions. </summary>
        public static ClassificationMultilabelPrimaryMetric IOU { get; } = new ClassificationMultilabelPrimaryMetric(IOUValue);
        /// <summary> Determines if two <see cref="ClassificationMultilabelPrimaryMetric"/> values are the same. </summary>
        public static bool operator ==(ClassificationMultilabelPrimaryMetric left, ClassificationMultilabelPrimaryMetric right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClassificationMultilabelPrimaryMetric"/> values are not the same. </summary>
        public static bool operator !=(ClassificationMultilabelPrimaryMetric left, ClassificationMultilabelPrimaryMetric right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClassificationMultilabelPrimaryMetric"/>. </summary>
        public static implicit operator ClassificationMultilabelPrimaryMetric(string value) => new ClassificationMultilabelPrimaryMetric(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClassificationMultilabelPrimaryMetric other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClassificationMultilabelPrimaryMetric other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
