// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The CategoricalDataDriftMetric. </summary>
    public readonly partial struct CategoricalDataDriftMetric : IEquatable<CategoricalDataDriftMetric>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CategoricalDataDriftMetric"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CategoricalDataDriftMetric(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JensenShannonDistanceValue = "JensenShannonDistance";
        private const string PopulationStabilityIndexValue = "PopulationStabilityIndex";
        private const string PearsonsChiSquaredTestValue = "PearsonsChiSquaredTest";

        /// <summary> The Jensen Shannon Distance (JSD) metric. </summary>
        public static CategoricalDataDriftMetric JensenShannonDistance { get; } = new CategoricalDataDriftMetric(JensenShannonDistanceValue);
        /// <summary> The Population Stability Index (PSI) metric. </summary>
        public static CategoricalDataDriftMetric PopulationStabilityIndex { get; } = new CategoricalDataDriftMetric(PopulationStabilityIndexValue);
        /// <summary> The Pearsons Chi Squared Test metric. </summary>
        public static CategoricalDataDriftMetric PearsonsChiSquaredTest { get; } = new CategoricalDataDriftMetric(PearsonsChiSquaredTestValue);
        /// <summary> Determines if two <see cref="CategoricalDataDriftMetric"/> values are the same. </summary>
        public static bool operator ==(CategoricalDataDriftMetric left, CategoricalDataDriftMetric right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CategoricalDataDriftMetric"/> values are not the same. </summary>
        public static bool operator !=(CategoricalDataDriftMetric left, CategoricalDataDriftMetric right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CategoricalDataDriftMetric"/>. </summary>
        public static implicit operator CategoricalDataDriftMetric(string value) => new CategoricalDataDriftMetric(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CategoricalDataDriftMetric other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CategoricalDataDriftMetric other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
