// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class BlobReferenceSasResult : IUtf8JsonSerializable, IJsonModel<BlobReferenceSasResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BlobReferenceSasResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BlobReferenceSasResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BlobReferenceSasResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BlobReferenceSasResult)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(BlobReferenceForConsumption))
            {
                if (BlobReferenceForConsumption != null)
                {
                    writer.WritePropertyName("blobReferenceForConsumption"u8);
                    writer.WriteObjectValue(BlobReferenceForConsumption, options);
                }
                else
                {
                    writer.WriteNull("blobReferenceForConsumption");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BlobReferenceSasResult IJsonModel<BlobReferenceSasResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BlobReferenceSasResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BlobReferenceSasResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBlobReferenceSasResult(document.RootElement, options);
        }

        internal static BlobReferenceSasResult DeserializeBlobReferenceSasResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            GetBlobReferenceForConsumptionDto blobReferenceForConsumption = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("blobReferenceForConsumption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        blobReferenceForConsumption = null;
                        continue;
                    }
                    blobReferenceForConsumption = GetBlobReferenceForConsumptionDto.DeserializeGetBlobReferenceForConsumptionDto(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BlobReferenceSasResult(blobReferenceForConsumption, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BlobReferenceForConsumption), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  blobReferenceForConsumption: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BlobReferenceForConsumption))
                {
                    builder.Append("  blobReferenceForConsumption: ");
                    BicepSerializationHelpers.AppendChildObject(builder, BlobReferenceForConsumption, options, 2, false, "  blobReferenceForConsumption: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<BlobReferenceSasResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BlobReferenceSasResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(BlobReferenceSasResult)} does not support writing '{options.Format}' format.");
            }
        }

        BlobReferenceSasResult IPersistableModel<BlobReferenceSasResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BlobReferenceSasResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBlobReferenceSasResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BlobReferenceSasResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BlobReferenceSasResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
