// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> BlobReferenceSASRequest for getBlobReferenceSAS API. </summary>
    public partial class BlobReferenceSasContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BlobReferenceSasContent"/>. </summary>
        public BlobReferenceSasContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BlobReferenceSasContent"/>. </summary>
        /// <param name="assetId"> Id of the asset to be accessed. </param>
        /// <param name="blobUri"> Blob uri of the asset to be accessed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BlobReferenceSasContent(string assetId, Uri blobUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AssetId = assetId;
            BlobUri = blobUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id of the asset to be accessed. </summary>
        [WirePath("assetId")]
        public string AssetId { get; set; }
        /// <summary> Blob uri of the asset to be accessed. </summary>
        [WirePath("blobUri")]
        public Uri BlobUri { get; set; }
    }
}
