// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Defines a Sampling Algorithm that generates values based on previous values. </summary>
    public partial class BayesianSamplingAlgorithm : SamplingAlgorithm
    {
        /// <summary> Initializes a new instance of <see cref="BayesianSamplingAlgorithm"/>. </summary>
        public BayesianSamplingAlgorithm()
        {
            SamplingAlgorithmType = SamplingAlgorithmType.Bayesian;
        }

        /// <summary> Initializes a new instance of <see cref="BayesianSamplingAlgorithm"/>. </summary>
        /// <param name="samplingAlgorithmType"> [Required] The algorithm used for generating hyperparameter values, along with configuration properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BayesianSamplingAlgorithm(SamplingAlgorithmType samplingAlgorithmType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(samplingAlgorithmType, serializedAdditionalRawData)
        {
            SamplingAlgorithmType = samplingAlgorithmType;
        }
    }
}
