// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Batch endpoint default values. </summary>
    internal partial class BatchEndpointDefaults
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchEndpointDefaults"/>. </summary>
        public BatchEndpointDefaults()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BatchEndpointDefaults"/>. </summary>
        /// <param name="deploymentName">
        /// Name of the deployment that will be default for the endpoint.
        /// This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchEndpointDefaults(string deploymentName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeploymentName = deploymentName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Name of the deployment that will be default for the endpoint.
        /// This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        /// </summary>
        [WirePath("deploymentName")]
        public string DeploymentName { get; set; }
    }
}
