// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Webhook details specific for Azure DevOps. </summary>
    public partial class AzureDevOpsWebhook : MachineLearningWebhook
    {
        /// <summary> Initializes a new instance of <see cref="AzureDevOpsWebhook"/>. </summary>
        public AzureDevOpsWebhook()
        {
            WebhookType = MachineLearningWebhookType.AzureDevOps;
        }

        /// <summary> Initializes a new instance of <see cref="AzureDevOpsWebhook"/>. </summary>
        /// <param name="webhookType"> [Required] Specifies the type of service to send a callback. </param>
        /// <param name="eventType"> Send callback on a specified notification event. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureDevOpsWebhook(MachineLearningWebhookType webhookType, string eventType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(webhookType, eventType, serializedAdditionalRawData)
        {
            WebhookType = webhookType;
        }
    }
}
