// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Access credential with no credentials. </summary>
    public partial class AnonymousAccessCredential : DataReferenceCredential
    {
        /// <summary> Initializes a new instance of <see cref="AnonymousAccessCredential"/>. </summary>
        internal AnonymousAccessCredential()
        {
            CredentialType = DataReferenceCredentialType.NoCredentials;
        }

        /// <summary> Initializes a new instance of <see cref="AnonymousAccessCredential"/>. </summary>
        /// <param name="credentialType"> [Required] Credential type used to authentication with storage. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnonymousAccessCredential(DataReferenceCredentialType credentialType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(credentialType, serializedAdditionalRawData)
        {
            CredentialType = credentialType;
        }
    }
}
