// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> scale settings for AML Compute. </summary>
    public partial class AmlComputeScaleSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AmlComputeScaleSettings"/>. </summary>
        /// <param name="maxNodeCount"> Max number of nodes to use. </param>
        public AmlComputeScaleSettings(int maxNodeCount)
        {
            MaxNodeCount = maxNodeCount;
        }

        /// <summary> Initializes a new instance of <see cref="AmlComputeScaleSettings"/>. </summary>
        /// <param name="maxNodeCount"> Max number of nodes to use. </param>
        /// <param name="minNodeCount"> Min number of nodes to use. </param>
        /// <param name="nodeIdleTimeBeforeScaleDown"> Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AmlComputeScaleSettings(int maxNodeCount, int? minNodeCount, TimeSpan? nodeIdleTimeBeforeScaleDown, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MaxNodeCount = maxNodeCount;
            MinNodeCount = minNodeCount;
            NodeIdleTimeBeforeScaleDown = nodeIdleTimeBeforeScaleDown;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AmlComputeScaleSettings"/> for deserialization. </summary>
        internal AmlComputeScaleSettings()
        {
        }

        /// <summary> Max number of nodes to use. </summary>
        [WirePath("maxNodeCount")]
        public int MaxNodeCount { get; set; }
        /// <summary> Min number of nodes to use. </summary>
        [WirePath("minNodeCount")]
        public int? MinNodeCount { get; set; }
        /// <summary> Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format. </summary>
        [WirePath("nodeIdleTimeBeforeScaleDown")]
        public TimeSpan? NodeIdleTimeBeforeScaleDown { get; set; }
    }
}
