// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> AML Compute properties. </summary>
    public partial class AmlComputeProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AmlComputeProperties"/>. </summary>
        public AmlComputeProperties()
        {
            Errors = new ChangeTrackingList<MachineLearningError>();
        }

        /// <summary> Initializes a new instance of <see cref="AmlComputeProperties"/>. </summary>
        /// <param name="osType"> Compute OS Type. </param>
        /// <param name="vmSize"> Virtual Machine Size. </param>
        /// <param name="vmPriority"> Virtual Machine priority. </param>
        /// <param name="virtualMachineImage"> Virtual Machine image for AML Compute - windows only. </param>
        /// <param name="isolatedNetwork"> Network is isolated or not. </param>
        /// <param name="scaleSettings"> Scale settings for AML Compute. </param>
        /// <param name="userAccountCredentials"> Credentials for an administrator user account that will be created on each compute node. </param>
        /// <param name="subnet"> Virtual network subnet resource ID the compute nodes belong to. </param>
        /// <param name="remoteLoginPortPublicAccess"> State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled. </param>
        /// <param name="allocationState"> Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute. </param>
        /// <param name="allocationStateTransitionOn"> The time at which the compute entered its current allocation state. </param>
        /// <param name="errors"> Collection of errors encountered by various compute nodes during node setup. </param>
        /// <param name="currentNodeCount"> The number of compute nodes currently assigned to the compute. </param>
        /// <param name="targetNodeCount"> The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation. </param>
        /// <param name="nodeStateCounts"> Counts of various node states on the compute. </param>
        /// <param name="enableNodePublicIP"> Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs. </param>
        /// <param name="propertyBag"> A property bag containing additional properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AmlComputeProperties(MachineLearningOSType? osType, string vmSize, MachineLearningVmPriority? vmPriority, VirtualMachineImage virtualMachineImage, bool? isolatedNetwork, AmlComputeScaleSettings scaleSettings, MachineLearningUserAccountCredentials userAccountCredentials, ResourceId subnet, MachineLearningRemoteLoginPortPublicAccess? remoteLoginPortPublicAccess, MachineLearningAllocationState? allocationState, DateTimeOffset? allocationStateTransitionOn, IReadOnlyList<MachineLearningError> errors, int? currentNodeCount, int? targetNodeCount, MachineLearningNodeStateCounts nodeStateCounts, bool? enableNodePublicIP, BinaryData propertyBag, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OSType = osType;
            VmSize = vmSize;
            VmPriority = vmPriority;
            VirtualMachineImage = virtualMachineImage;
            IsolatedNetwork = isolatedNetwork;
            ScaleSettings = scaleSettings;
            UserAccountCredentials = userAccountCredentials;
            Subnet = subnet;
            RemoteLoginPortPublicAccess = remoteLoginPortPublicAccess;
            AllocationState = allocationState;
            AllocationStateTransitionOn = allocationStateTransitionOn;
            Errors = errors;
            CurrentNodeCount = currentNodeCount;
            TargetNodeCount = targetNodeCount;
            NodeStateCounts = nodeStateCounts;
            EnableNodePublicIP = enableNodePublicIP;
            PropertyBag = propertyBag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Compute OS Type. </summary>
        [WirePath("osType")]
        public MachineLearningOSType? OSType { get; set; }
        /// <summary> Virtual Machine Size. </summary>
        [WirePath("vmSize")]
        public string VmSize { get; set; }
        /// <summary> Virtual Machine priority. </summary>
        [WirePath("vmPriority")]
        public MachineLearningVmPriority? VmPriority { get; set; }
        /// <summary> Virtual Machine image for AML Compute - windows only. </summary>
        internal VirtualMachineImage VirtualMachineImage { get; set; }
        /// <summary> Virtual Machine image path. </summary>
        [WirePath("virtualMachineImage.id")]
        public string VirtualMachineImageId
        {
            get => VirtualMachineImage is null ? default : VirtualMachineImage.Id;
            set => VirtualMachineImage = new VirtualMachineImage(value);
        }

        /// <summary> Network is isolated or not. </summary>
        [WirePath("isolatedNetwork")]
        public bool? IsolatedNetwork { get; set; }
        /// <summary> Scale settings for AML Compute. </summary>
        [WirePath("scaleSettings")]
        public AmlComputeScaleSettings ScaleSettings { get; set; }
        /// <summary> Credentials for an administrator user account that will be created on each compute node. </summary>
        [WirePath("userAccountCredentials")]
        public MachineLearningUserAccountCredentials UserAccountCredentials { get; set; }
        /// <summary> Virtual network subnet resource ID the compute nodes belong to. </summary>
        internal ResourceId Subnet { get; set; }
        /// <summary> The ID of the resource. </summary>
        [WirePath("subnet.id")]
        public ResourceIdentifier SubnetId
        {
            get => Subnet is null ? default : Subnet.Id;
            set => Subnet = new ResourceId(value);
        }

        /// <summary> State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled. </summary>
        [WirePath("remoteLoginPortPublicAccess")]
        public MachineLearningRemoteLoginPortPublicAccess? RemoteLoginPortPublicAccess { get; set; }
        /// <summary> Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute. </summary>
        [WirePath("allocationState")]
        public MachineLearningAllocationState? AllocationState { get; }
        /// <summary> The time at which the compute entered its current allocation state. </summary>
        [WirePath("allocationStateTransitionTime")]
        public DateTimeOffset? AllocationStateTransitionOn { get; }
        /// <summary> Collection of errors encountered by various compute nodes during node setup. </summary>
        [WirePath("errors")]
        public IReadOnlyList<MachineLearningError> Errors { get; }
        /// <summary> The number of compute nodes currently assigned to the compute. </summary>
        [WirePath("currentNodeCount")]
        public int? CurrentNodeCount { get; }
        /// <summary> The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation. </summary>
        [WirePath("targetNodeCount")]
        public int? TargetNodeCount { get; }
        /// <summary> Counts of various node states on the compute. </summary>
        [WirePath("nodeStateCounts")]
        public MachineLearningNodeStateCounts NodeStateCounts { get; }
        /// <summary> Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs. </summary>
        [WirePath("enableNodePublicIp")]
        public bool? EnableNodePublicIP { get; set; }
        /// <summary>
        /// A property bag containing additional properties.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("propertyBag")]
        public BinaryData PropertyBag { get; set; }
    }
}
