// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.MachineLearning.Models;

namespace Azure.ResourceManager.MachineLearning
{
    /// <summary>
    /// A class representing a collection of <see cref="MachineLearningRegistryEnvironmentContainerResource"/> and their operations.
    /// Each <see cref="MachineLearningRegistryEnvironmentContainerResource"/> in the collection will belong to the same instance of <see cref="MachineLearningRegistryResource"/>.
    /// To get a <see cref="MachineLearningRegistryEnvironmentContainerCollection"/> instance call the GetMachineLearningRegistryEnvironmentContainers method from an instance of <see cref="MachineLearningRegistryResource"/>.
    /// </summary>
    public partial class MachineLearningRegistryEnvironmentContainerCollection : ArmCollection, IEnumerable<MachineLearningRegistryEnvironmentContainerResource>, IAsyncEnumerable<MachineLearningRegistryEnvironmentContainerResource>
    {
        private readonly ClientDiagnostics _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics;
        private readonly RegistryEnvironmentContainersRestOperations _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient;

        /// <summary> Initializes a new instance of the <see cref="MachineLearningRegistryEnvironmentContainerCollection"/> class for mocking. </summary>
        protected MachineLearningRegistryEnvironmentContainerCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MachineLearningRegistryEnvironmentContainerCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal MachineLearningRegistryEnvironmentContainerCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.MachineLearning", MachineLearningRegistryEnvironmentContainerResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(MachineLearningRegistryEnvironmentContainerResource.ResourceType, out string machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersApiVersion);
            _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient = new RegistryEnvironmentContainersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != MachineLearningRegistryResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, MachineLearningRegistryResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update container.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="environmentName"> Container name. </param>
        /// <param name="data"> Container entity to create or update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="environmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="environmentName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<MachineLearningRegistryEnvironmentContainerResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string environmentName, MachineLearningEnvironmentContainerData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(environmentName, nameof(environmentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics.CreateScope("MachineLearningRegistryEnvironmentContainerCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, data, cancellationToken).ConfigureAwait(false);
                var operation = new MachineLearningArmOperation<MachineLearningRegistryEnvironmentContainerResource>(new MachineLearningRegistryEnvironmentContainerOperationSource(Client), _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics, Pipeline, _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, data).Request, response, OperationFinalStateVia.OriginalUri);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update container.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="environmentName"> Container name. </param>
        /// <param name="data"> Container entity to create or update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="environmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="environmentName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<MachineLearningRegistryEnvironmentContainerResource> CreateOrUpdate(WaitUntil waitUntil, string environmentName, MachineLearningEnvironmentContainerData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(environmentName, nameof(environmentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics.CreateScope("MachineLearningRegistryEnvironmentContainerCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, data, cancellationToken);
                var operation = new MachineLearningArmOperation<MachineLearningRegistryEnvironmentContainerResource>(new MachineLearningRegistryEnvironmentContainerOperationSource(Client), _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics, Pipeline, _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, data).Request, response, OperationFinalStateVia.OriginalUri);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get container.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="environmentName"> Container name. This is case-sensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="environmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="environmentName"/> is null. </exception>
        public virtual async Task<Response<MachineLearningRegistryEnvironmentContainerResource>> GetAsync(string environmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(environmentName, nameof(environmentName));

            using var scope = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics.CreateScope("MachineLearningRegistryEnvironmentContainerCollection.Get");
            scope.Start();
            try
            {
                var response = await _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MachineLearningRegistryEnvironmentContainerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get container.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="environmentName"> Container name. This is case-sensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="environmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="environmentName"/> is null. </exception>
        public virtual Response<MachineLearningRegistryEnvironmentContainerResource> Get(string environmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(environmentName, nameof(environmentName));

            using var scope = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics.CreateScope("MachineLearningRegistryEnvironmentContainerCollection.Get");
            scope.Start();
            try
            {
                var response = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MachineLearningRegistryEnvironmentContainerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List environment containers.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="skip"> Continuation token for pagination. </param>
        /// <param name="listViewType"> View type for including/excluding (for example) archived entities. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="MachineLearningRegistryEnvironmentContainerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<MachineLearningRegistryEnvironmentContainerResource> GetAllAsync(string skip = null, MachineLearningListViewType? listViewType = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, skip, listViewType);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, skip, listViewType);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new MachineLearningRegistryEnvironmentContainerResource(Client, MachineLearningEnvironmentContainerData.DeserializeMachineLearningEnvironmentContainerData(e)), _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics, Pipeline, "MachineLearningRegistryEnvironmentContainerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List environment containers.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="skip"> Continuation token for pagination. </param>
        /// <param name="listViewType"> View type for including/excluding (for example) archived entities. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="MachineLearningRegistryEnvironmentContainerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<MachineLearningRegistryEnvironmentContainerResource> GetAll(string skip = null, MachineLearningListViewType? listViewType = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, skip, listViewType);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, skip, listViewType);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new MachineLearningRegistryEnvironmentContainerResource(Client, MachineLearningEnvironmentContainerData.DeserializeMachineLearningEnvironmentContainerData(e)), _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics, Pipeline, "MachineLearningRegistryEnvironmentContainerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="environmentName"> Container name. This is case-sensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="environmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="environmentName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string environmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(environmentName, nameof(environmentName));

            using var scope = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics.CreateScope("MachineLearningRegistryEnvironmentContainerCollection.Exists");
            scope.Start();
            try
            {
                var response = await _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="environmentName"> Container name. This is case-sensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="environmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="environmentName"/> is null. </exception>
        public virtual Response<bool> Exists(string environmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(environmentName, nameof(environmentName));

            using var scope = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics.CreateScope("MachineLearningRegistryEnvironmentContainerCollection.Exists");
            scope.Start();
            try
            {
                var response = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="environmentName"> Container name. This is case-sensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="environmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="environmentName"/> is null. </exception>
        public virtual async Task<NullableResponse<MachineLearningRegistryEnvironmentContainerResource>> GetIfExistsAsync(string environmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(environmentName, nameof(environmentName));

            using var scope = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics.CreateScope("MachineLearningRegistryEnvironmentContainerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<MachineLearningRegistryEnvironmentContainerResource>(response.GetRawResponse());
                return Response.FromValue(new MachineLearningRegistryEnvironmentContainerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RegistryEnvironmentContainers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MachineLearningRegistryEnvironmentContainerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="environmentName"> Container name. This is case-sensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="environmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="environmentName"/> is null. </exception>
        public virtual NullableResponse<MachineLearningRegistryEnvironmentContainerResource> GetIfExists(string environmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(environmentName, nameof(environmentName));

            using var scope = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersClientDiagnostics.CreateScope("MachineLearningRegistryEnvironmentContainerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _machineLearningRegistryEnvironmentContainerRegistryEnvironmentContainersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, environmentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<MachineLearningRegistryEnvironmentContainerResource>(response.GetRawResponse());
                return Response.FromValue(new MachineLearningRegistryEnvironmentContainerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<MachineLearningRegistryEnvironmentContainerResource> IEnumerable<MachineLearningRegistryEnvironmentContainerResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<MachineLearningRegistryEnvironmentContainerResource> IAsyncEnumerable<MachineLearningRegistryEnvironmentContainerResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
