// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningWorkspaceOperationSource : IOperationSource<MachineLearningWorkspaceResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningWorkspaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningWorkspaceResource IOperationSource<MachineLearningWorkspaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningWorkspaceData.DeserializeMachineLearningWorkspaceData(document.RootElement);
            return new MachineLearningWorkspaceResource(_client, data);
        }

        async ValueTask<MachineLearningWorkspaceResource> IOperationSource<MachineLearningWorkspaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningWorkspaceData.DeserializeMachineLearningWorkspaceData(document.RootElement);
            return new MachineLearningWorkspaceResource(_client, data);
        }
    }
}
