// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningServerlessEndpointOperationSource : IOperationSource<MachineLearningServerlessEndpointResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningServerlessEndpointOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningServerlessEndpointResource IOperationSource<MachineLearningServerlessEndpointResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningServerlessEndpointData.DeserializeMachineLearningServerlessEndpointData(document.RootElement);
            return new MachineLearningServerlessEndpointResource(_client, data);
        }

        async ValueTask<MachineLearningServerlessEndpointResource> IOperationSource<MachineLearningServerlessEndpointResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningServerlessEndpointData.DeserializeMachineLearningServerlessEndpointData(document.RootElement);
            return new MachineLearningServerlessEndpointResource(_client, data);
        }
    }
}
