// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningRegistryOperationSource : IOperationSource<MachineLearningRegistryResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningRegistryOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningRegistryResource IOperationSource<MachineLearningRegistryResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningRegistryData.DeserializeMachineLearningRegistryData(document.RootElement);
            return new MachineLearningRegistryResource(_client, data);
        }

        async ValueTask<MachineLearningRegistryResource> IOperationSource<MachineLearningRegistryResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningRegistryData.DeserializeMachineLearningRegistryData(document.RootElement);
            return new MachineLearningRegistryResource(_client, data);
        }
    }
}
