// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningRegistryModelContainerOperationSource : IOperationSource<MachineLearningRegistryModelContainerResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningRegistryModelContainerOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningRegistryModelContainerResource IOperationSource<MachineLearningRegistryModelContainerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningModelContainerData.DeserializeMachineLearningModelContainerData(document.RootElement);
            return new MachineLearningRegistryModelContainerResource(_client, data);
        }

        async ValueTask<MachineLearningRegistryModelContainerResource> IOperationSource<MachineLearningRegistryModelContainerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningModelContainerData.DeserializeMachineLearningModelContainerData(document.RootElement);
            return new MachineLearningRegistryModelContainerResource(_client, data);
        }
    }
}
