// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningRegistryCodeVersionOperationSource : IOperationSource<MachineLearningRegistryCodeVersionResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningRegistryCodeVersionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningRegistryCodeVersionResource IOperationSource<MachineLearningRegistryCodeVersionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningCodeVersionData.DeserializeMachineLearningCodeVersionData(document.RootElement);
            return new MachineLearningRegistryCodeVersionResource(_client, data);
        }

        async ValueTask<MachineLearningRegistryCodeVersionResource> IOperationSource<MachineLearningRegistryCodeVersionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningCodeVersionData.DeserializeMachineLearningCodeVersionData(document.RootElement);
            return new MachineLearningRegistryCodeVersionResource(_client, data);
        }
    }
}
