// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningRegistryCodeContainerOperationSource : IOperationSource<MachineLearningRegistryCodeContainerResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningRegistryCodeContainerOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningRegistryCodeContainerResource IOperationSource<MachineLearningRegistryCodeContainerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningCodeContainerData.DeserializeMachineLearningCodeContainerData(document.RootElement);
            return new MachineLearningRegistryCodeContainerResource(_client, data);
        }

        async ValueTask<MachineLearningRegistryCodeContainerResource> IOperationSource<MachineLearningRegistryCodeContainerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningCodeContainerData.DeserializeMachineLearningCodeContainerData(document.RootElement);
            return new MachineLearningRegistryCodeContainerResource(_client, data);
        }
    }
}
