// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningOnlineEndpointOperationSource : IOperationSource<MachineLearningOnlineEndpointResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningOnlineEndpointOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningOnlineEndpointResource IOperationSource<MachineLearningOnlineEndpointResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningOnlineEndpointData.DeserializeMachineLearningOnlineEndpointData(document.RootElement);
            return new MachineLearningOnlineEndpointResource(_client, data);
        }

        async ValueTask<MachineLearningOnlineEndpointResource> IOperationSource<MachineLearningOnlineEndpointResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningOnlineEndpointData.DeserializeMachineLearningOnlineEndpointData(document.RootElement);
            return new MachineLearningOnlineEndpointResource(_client, data);
        }
    }
}
