// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningOnlineDeploymentOperationSource : IOperationSource<MachineLearningOnlineDeploymentResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningOnlineDeploymentOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningOnlineDeploymentResource IOperationSource<MachineLearningOnlineDeploymentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningOnlineDeploymentData.DeserializeMachineLearningOnlineDeploymentData(document.RootElement);
            return new MachineLearningOnlineDeploymentResource(_client, data);
        }

        async ValueTask<MachineLearningOnlineDeploymentResource> IOperationSource<MachineLearningOnlineDeploymentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningOnlineDeploymentData.DeserializeMachineLearningOnlineDeploymentData(document.RootElement);
            return new MachineLearningOnlineDeploymentResource(_client, data);
        }
    }
}
