// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningMarketplaceSubscriptionOperationSource : IOperationSource<MachineLearningMarketplaceSubscriptionResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningMarketplaceSubscriptionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningMarketplaceSubscriptionResource IOperationSource<MachineLearningMarketplaceSubscriptionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningMarketplaceSubscriptionData.DeserializeMachineLearningMarketplaceSubscriptionData(document.RootElement);
            return new MachineLearningMarketplaceSubscriptionResource(_client, data);
        }

        async ValueTask<MachineLearningMarketplaceSubscriptionResource> IOperationSource<MachineLearningMarketplaceSubscriptionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningMarketplaceSubscriptionData.DeserializeMachineLearningMarketplaceSubscriptionData(document.RootElement);
            return new MachineLearningMarketplaceSubscriptionResource(_client, data);
        }
    }
}
