// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningFeaturestoreEntityVersionOperationSource : IOperationSource<MachineLearningFeaturestoreEntityVersionResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningFeaturestoreEntityVersionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningFeaturestoreEntityVersionResource IOperationSource<MachineLearningFeaturestoreEntityVersionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningFeaturestoreEntityVersionData.DeserializeMachineLearningFeaturestoreEntityVersionData(document.RootElement);
            return new MachineLearningFeaturestoreEntityVersionResource(_client, data);
        }

        async ValueTask<MachineLearningFeaturestoreEntityVersionResource> IOperationSource<MachineLearningFeaturestoreEntityVersionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningFeaturestoreEntityVersionData.DeserializeMachineLearningFeaturestoreEntityVersionData(document.RootElement);
            return new MachineLearningFeaturestoreEntityVersionResource(_client, data);
        }
    }
}
