// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningFeatureStoreEntityContainerOperationSource : IOperationSource<MachineLearningFeatureStoreEntityContainerResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningFeatureStoreEntityContainerOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningFeatureStoreEntityContainerResource IOperationSource<MachineLearningFeatureStoreEntityContainerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningFeatureStoreEntityContainerData.DeserializeMachineLearningFeatureStoreEntityContainerData(document.RootElement);
            return new MachineLearningFeatureStoreEntityContainerResource(_client, data);
        }

        async ValueTask<MachineLearningFeatureStoreEntityContainerResource> IOperationSource<MachineLearningFeatureStoreEntityContainerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningFeatureStoreEntityContainerData.DeserializeMachineLearningFeatureStoreEntityContainerData(document.RootElement);
            return new MachineLearningFeatureStoreEntityContainerResource(_client, data);
        }
    }
}
