// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningFeatureSetVersionOperationSource : IOperationSource<MachineLearningFeatureSetVersionResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningFeatureSetVersionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningFeatureSetVersionResource IOperationSource<MachineLearningFeatureSetVersionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningFeatureSetVersionData.DeserializeMachineLearningFeatureSetVersionData(document.RootElement);
            return new MachineLearningFeatureSetVersionResource(_client, data);
        }

        async ValueTask<MachineLearningFeatureSetVersionResource> IOperationSource<MachineLearningFeatureSetVersionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningFeatureSetVersionData.DeserializeMachineLearningFeatureSetVersionData(document.RootElement);
            return new MachineLearningFeatureSetVersionResource(_client, data);
        }
    }
}
