// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningFeatureSetContainerOperationSource : IOperationSource<MachineLearningFeatureSetContainerResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningFeatureSetContainerOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningFeatureSetContainerResource IOperationSource<MachineLearningFeatureSetContainerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningFeatureSetContainerData.DeserializeMachineLearningFeatureSetContainerData(document.RootElement);
            return new MachineLearningFeatureSetContainerResource(_client, data);
        }

        async ValueTask<MachineLearningFeatureSetContainerResource> IOperationSource<MachineLearningFeatureSetContainerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningFeatureSetContainerData.DeserializeMachineLearningFeatureSetContainerData(document.RootElement);
            return new MachineLearningFeatureSetContainerResource(_client, data);
        }
    }
}
