// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningBatchEndpointOperationSource : IOperationSource<MachineLearningBatchEndpointResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningBatchEndpointOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningBatchEndpointResource IOperationSource<MachineLearningBatchEndpointResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningBatchEndpointData.DeserializeMachineLearningBatchEndpointData(document.RootElement);
            return new MachineLearningBatchEndpointResource(_client, data);
        }

        async ValueTask<MachineLearningBatchEndpointResource> IOperationSource<MachineLearningBatchEndpointResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningBatchEndpointData.DeserializeMachineLearningBatchEndpointData(document.RootElement);
            return new MachineLearningBatchEndpointResource(_client, data);
        }
    }
}
