// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearningBatchDeploymentOperationSource : IOperationSource<MachineLearningBatchDeploymentResource>
    {
        private readonly ArmClient _client;

        internal MachineLearningBatchDeploymentOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearningBatchDeploymentResource IOperationSource<MachineLearningBatchDeploymentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningBatchDeploymentData.DeserializeMachineLearningBatchDeploymentData(document.RootElement);
            return new MachineLearningBatchDeploymentResource(_client, data);
        }

        async ValueTask<MachineLearningBatchDeploymentResource> IOperationSource<MachineLearningBatchDeploymentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningBatchDeploymentData.DeserializeMachineLearningBatchDeploymentData(document.RootElement);
            return new MachineLearningBatchDeploymentResource(_client, data);
        }
    }
}
