// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearninRegistryComponentVersionOperationSource : IOperationSource<MachineLearninRegistryComponentVersionResource>
    {
        private readonly ArmClient _client;

        internal MachineLearninRegistryComponentVersionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearninRegistryComponentVersionResource IOperationSource<MachineLearninRegistryComponentVersionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningComponentVersionData.DeserializeMachineLearningComponentVersionData(document.RootElement);
            return new MachineLearninRegistryComponentVersionResource(_client, data);
        }

        async ValueTask<MachineLearninRegistryComponentVersionResource> IOperationSource<MachineLearninRegistryComponentVersionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningComponentVersionData.DeserializeMachineLearningComponentVersionData(document.RootElement);
            return new MachineLearninRegistryComponentVersionResource(_client, data);
        }
    }
}
