// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning
{
    internal class MachineLearninRegistryComponentContainerOperationSource : IOperationSource<MachineLearninRegistryComponentContainerResource>
    {
        private readonly ArmClient _client;

        internal MachineLearninRegistryComponentContainerOperationSource(ArmClient client)
        {
            _client = client;
        }

        MachineLearninRegistryComponentContainerResource IOperationSource<MachineLearninRegistryComponentContainerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MachineLearningComponentContainerData.DeserializeMachineLearningComponentContainerData(document.RootElement);
            return new MachineLearninRegistryComponentContainerResource(_client, data);
        }

        async ValueTask<MachineLearninRegistryComponentContainerResource> IOperationSource<MachineLearninRegistryComponentContainerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MachineLearningComponentContainerData.DeserializeMachineLearningComponentContainerData(document.RootElement);
            return new MachineLearninRegistryComponentContainerResource(_client, data);
        }
    }
}
