// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmMachineLearningModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningError"/>. </summary>
        /// <param name="error"> The error object. </param>
        /// <returns> A new <see cref="Models.MachineLearningError"/> instance for mocking. </returns>
        public static MachineLearningError MachineLearningError(ResponseError error = null)
        {
            return new MachineLearningError(error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningWorkspaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="kind"></param>
        /// <param name="sku"> The sku of the workspace. </param>
        /// <param name="workspaceId"> The immutable id associated with this workspace. </param>
        /// <param name="description"> The description of this workspace. </param>
        /// <param name="friendlyName"> The friendly name for this workspace. This name in mutable. </param>
        /// <param name="keyVault"> ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created. </param>
        /// <param name="applicationInsights"> ARM id of the application insights associated with this workspace. </param>
        /// <param name="containerRegistry"> ARM id of the container registry associated with this workspace. </param>
        /// <param name="storageAccount"> ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created. </param>
        /// <param name="discoveryUri"> Url for the discovery service to identify regional endpoints for machine learning experimentation services. </param>
        /// <param name="provisioningState"> The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning. </param>
        /// <param name="encryption"> The encryption settings of Azure ML workspace. </param>
        /// <param name="isHbiWorkspace"> The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service. </param>
        /// <param name="serviceProvisionedResourceGroup"> The name of the managed resource group created by workspace RP in customer subscription if the workspace is CMK workspace. </param>
        /// <param name="privateLinkCount"> Count of private connections in the workspace. </param>
        /// <param name="imageBuildCompute"> The compute name for image build. </param>
        /// <param name="allowPublicAccessWhenBehindVnet"> The flag to indicate whether to allow public access when behind VNet. </param>
        /// <param name="publicNetworkAccessType"> Whether requests from Public Network are allowed. </param>
        /// <param name="privateEndpointConnections"> The list of private endpoint connections in the workspace. </param>
        /// <param name="serverlessComputeSettings"> Settings for serverless compute created in the workspace. </param>
        /// <param name="sharedPrivateLinkResources"> The list of shared private link resources in this workspace. </param>
        /// <param name="notebookInfo"> The notebook info of Azure ML workspace. </param>
        /// <param name="cosmosDbCollectionsThroughput"> The service managed resource settings. </param>
        /// <param name="primaryUserAssignedIdentity"> The user assigned identity resource id that represents the workspace identity. </param>
        /// <param name="tenantId"> The tenant id associated with this workspace. </param>
        /// <param name="isStorageHnsEnabled"> If the storage associated with the workspace has hierarchical namespace(HNS) enabled. </param>
        /// <param name="mlFlowTrackingUri"> The URI associated with this workspace that machine learning flow must point at to set up tracking. </param>
        /// <param name="isV1LegacyMode"> Enabling v1_legacy_mode may prevent you from using features provided by the v2 API. </param>
        /// <param name="managedNetwork"> Managed Network settings for a machine learning workspace. </param>
        /// <param name="featureStoreSettings"> Settings for feature store type workspace. </param>
        /// <param name="associatedWorkspaces"></param>
        /// <param name="enableDataIsolation"></param>
        /// <param name="hubResourceId"></param>
        /// <param name="workspaceHubConfig"> WorkspaceHub's configuration object. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningWorkspaceData"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceData MachineLearningWorkspaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, string kind = null, MachineLearningSku sku = null, string workspaceId = null, string description = null, string friendlyName = null, string keyVault = null, string applicationInsights = null, string containerRegistry = null, string storageAccount = null, Uri discoveryUri = null, MachineLearningProvisioningState? provisioningState = null, MachineLearningEncryptionSetting encryption = null, bool? isHbiWorkspace = null, string serviceProvisionedResourceGroup = null, int? privateLinkCount = null, string imageBuildCompute = null, bool? allowPublicAccessWhenBehindVnet = null, PublicNetworkAccess? publicNetworkAccessType = null, IEnumerable<MachineLearningPrivateEndpointConnectionData> privateEndpointConnections = null, ServerlessComputeSettings serverlessComputeSettings = null, IEnumerable<MachineLearningSharedPrivateLinkResource> sharedPrivateLinkResources = null, MachineLearningNotebookResourceInfo notebookInfo = null, int? cosmosDbCollectionsThroughput = null, string primaryUserAssignedIdentity = null, Guid? tenantId = null, bool? isStorageHnsEnabled = null, Uri mlFlowTrackingUri = null, bool? isV1LegacyMode = null, ManagedNetworkSettings managedNetwork = null, FeatureStoreSettings featureStoreSettings = null, IEnumerable<string> associatedWorkspaces = null, bool? enableDataIsolation = null, ResourceIdentifier hubResourceId = null, WorkspaceHubConfig workspaceHubConfig = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<MachineLearningPrivateEndpointConnectionData>();
            sharedPrivateLinkResources ??= new List<MachineLearningSharedPrivateLinkResource>();
            associatedWorkspaces ??= new List<string>();

            return new MachineLearningWorkspaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                kind,
                sku,
                workspaceId,
                description,
                friendlyName,
                keyVault,
                applicationInsights,
                containerRegistry,
                storageAccount,
                discoveryUri,
                provisioningState,
                encryption,
                isHbiWorkspace,
                serviceProvisionedResourceGroup,
                privateLinkCount,
                imageBuildCompute,
                allowPublicAccessWhenBehindVnet,
                publicNetworkAccessType,
                privateEndpointConnections?.ToList(),
                serverlessComputeSettings,
                sharedPrivateLinkResources?.ToList(),
                notebookInfo,
                cosmosDbCollectionsThroughput != null ? new ServiceManagedResourcesSettings(new CosmosDbSettings(cosmosDbCollectionsThroughput, serializedAdditionalRawData: null), serializedAdditionalRawData: null) : null,
                primaryUserAssignedIdentity,
                tenantId,
                isStorageHnsEnabled,
                mlFlowTrackingUri,
                isV1LegacyMode,
                managedNetwork,
                featureStoreSettings,
                associatedWorkspaces?.ToList(),
                enableDataIsolation,
                hubResourceId,
                workspaceHubConfig,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="sku"> The sku of the workspace. </param>
        /// <param name="subResourceId"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static MachineLearningPrivateEndpointConnectionData MachineLearningPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, MachineLearningSku sku = null, ResourceIdentifier subResourceId = null, MachineLearningPrivateLinkServiceConnectionState connectionState = null, MachineLearningPrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MachineLearningPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                sku,
                subResourceId != null ? ResourceManagerModelFactory.SubResource(subResourceId) : null,
                connectionState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateEndpointBase"/>. </summary>
        /// <param name="id"> The ARM identifier for Private Endpoint. </param>
        /// <returns> A new <see cref="Models.PrivateEndpointBase"/> instance for mocking. </returns>
        public static PrivateEndpointBase PrivateEndpointBase(ResourceIdentifier id = null)
        {
            return new PrivateEndpointBase(id, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningNotebookResourceInfo"/>. </summary>
        /// <param name="fqdn"></param>
        /// <param name="resourceId"> the data plane resourceId that used to initialize notebook component. </param>
        /// <param name="notebookPreparationError"> The error that occurs when preparing notebook. </param>
        /// <returns> A new <see cref="Models.MachineLearningNotebookResourceInfo"/> instance for mocking. </returns>
        public static MachineLearningNotebookResourceInfo MachineLearningNotebookResourceInfo(string fqdn = null, string resourceId = null, MachineLearningNotebookPreparationError notebookPreparationError = null)
        {
            return new MachineLearningNotebookResourceInfo(fqdn, resourceId, notebookPreparationError, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningNotebookPreparationError"/>. </summary>
        /// <param name="errorMessage"></param>
        /// <param name="statusCode"></param>
        /// <returns> A new <see cref="Models.MachineLearningNotebookPreparationError"/> instance for mocking. </returns>
        public static MachineLearningNotebookPreparationError MachineLearningNotebookPreparationError(string errorMessage = null, int? statusCode = null)
        {
            return new MachineLearningNotebookPreparationError(errorMessage, statusCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedNetworkSettings"/>. </summary>
        /// <param name="isolationMode"> Isolation mode for the managed network of a machine learning workspace. </param>
        /// <param name="networkId"></param>
        /// <param name="outboundRules">
        /// Dictionary of &lt;OutboundRule&gt;
        /// Please note <see cref="MachineLearningOutboundRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FqdnOutboundRule"/>, <see cref="PrivateEndpointOutboundRule"/> and <see cref="ServiceTagOutboundRule"/>.
        /// </param>
        /// <param name="status"> Status of the Provisioning for the managed network of a machine learning workspace. </param>
        /// <returns> A new <see cref="Models.ManagedNetworkSettings"/> instance for mocking. </returns>
        public static ManagedNetworkSettings ManagedNetworkSettings(IsolationMode? isolationMode = null, string networkId = null, IDictionary<string, MachineLearningOutboundRule> outboundRules = null, ManagedNetworkProvisionStatus status = null)
        {
            outboundRules ??= new Dictionary<string, MachineLearningOutboundRule>();

            return new ManagedNetworkSettings(isolationMode, networkId, outboundRules, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningWorkspaceDiagnoseResult"/>. </summary>
        /// <param name="value"></param>
        /// <returns> A new <see cref="Models.MachineLearningWorkspaceDiagnoseResult"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceDiagnoseResult MachineLearningWorkspaceDiagnoseResult(MachineLearningDiagnoseResultValue value = null)
        {
            return new MachineLearningWorkspaceDiagnoseResult(value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDiagnoseResultValue"/>. </summary>
        /// <param name="userDefinedRouteResults"></param>
        /// <param name="networkSecurityRuleResults"></param>
        /// <param name="resourceLockResults"></param>
        /// <param name="dnsResolutionResults"></param>
        /// <param name="storageAccountResults"></param>
        /// <param name="keyVaultResults"></param>
        /// <param name="containerRegistryResults"></param>
        /// <param name="applicationInsightsResults"></param>
        /// <param name="otherResults"></param>
        /// <returns> A new <see cref="Models.MachineLearningDiagnoseResultValue"/> instance for mocking. </returns>
        public static MachineLearningDiagnoseResultValue MachineLearningDiagnoseResultValue(IEnumerable<MachineLearningDiagnoseResult> userDefinedRouteResults = null, IEnumerable<MachineLearningDiagnoseResult> networkSecurityRuleResults = null, IEnumerable<MachineLearningDiagnoseResult> resourceLockResults = null, IEnumerable<MachineLearningDiagnoseResult> dnsResolutionResults = null, IEnumerable<MachineLearningDiagnoseResult> storageAccountResults = null, IEnumerable<MachineLearningDiagnoseResult> keyVaultResults = null, IEnumerable<MachineLearningDiagnoseResult> containerRegistryResults = null, IEnumerable<MachineLearningDiagnoseResult> applicationInsightsResults = null, IEnumerable<MachineLearningDiagnoseResult> otherResults = null)
        {
            userDefinedRouteResults ??= new List<MachineLearningDiagnoseResult>();
            networkSecurityRuleResults ??= new List<MachineLearningDiagnoseResult>();
            resourceLockResults ??= new List<MachineLearningDiagnoseResult>();
            dnsResolutionResults ??= new List<MachineLearningDiagnoseResult>();
            storageAccountResults ??= new List<MachineLearningDiagnoseResult>();
            keyVaultResults ??= new List<MachineLearningDiagnoseResult>();
            containerRegistryResults ??= new List<MachineLearningDiagnoseResult>();
            applicationInsightsResults ??= new List<MachineLearningDiagnoseResult>();
            otherResults ??= new List<MachineLearningDiagnoseResult>();

            return new MachineLearningDiagnoseResultValue(
                userDefinedRouteResults?.ToList(),
                networkSecurityRuleResults?.ToList(),
                resourceLockResults?.ToList(),
                dnsResolutionResults?.ToList(),
                storageAccountResults?.ToList(),
                keyVaultResults?.ToList(),
                containerRegistryResults?.ToList(),
                applicationInsightsResults?.ToList(),
                otherResults?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDiagnoseResult"/>. </summary>
        /// <param name="code"> Code for workspace setup error. </param>
        /// <param name="level"> Level of workspace setup error. </param>
        /// <param name="message"> Message of workspace setup error. </param>
        /// <returns> A new <see cref="Models.MachineLearningDiagnoseResult"/> instance for mocking. </returns>
        public static MachineLearningDiagnoseResult MachineLearningDiagnoseResult(string code = null, MachineLearningDiagnoseResultLevel? level = null, string message = null)
        {
            return new MachineLearningDiagnoseResult(code, level, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningWorkspaceGetKeysResult"/>. </summary>
        /// <param name="userStorageKey"></param>
        /// <param name="userStorageResourceId"></param>
        /// <param name="appInsightsInstrumentationKey"></param>
        /// <param name="containerRegistryCredentials"></param>
        /// <param name="notebookAccessKeys"></param>
        /// <returns> A new <see cref="Models.MachineLearningWorkspaceGetKeysResult"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceGetKeysResult MachineLearningWorkspaceGetKeysResult(string userStorageKey = null, string userStorageResourceId = null, string appInsightsInstrumentationKey = null, MachineLearningContainerRegistryCredentials containerRegistryCredentials = null, MachineLearningWorkspaceGetNotebookKeysResult notebookAccessKeys = null)
        {
            return new MachineLearningWorkspaceGetKeysResult(
                userStorageKey,
                userStorageResourceId,
                appInsightsInstrumentationKey,
                containerRegistryCredentials,
                notebookAccessKeys,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningContainerRegistryCredentials"/>. </summary>
        /// <param name="location"></param>
        /// <param name="username"></param>
        /// <param name="passwords"></param>
        /// <returns> A new <see cref="Models.MachineLearningContainerRegistryCredentials"/> instance for mocking. </returns>
        public static MachineLearningContainerRegistryCredentials MachineLearningContainerRegistryCredentials(AzureLocation? location = null, string username = null, IEnumerable<MachineLearningPasswordDetail> passwords = null)
        {
            passwords ??= new List<MachineLearningPasswordDetail>();

            return new MachineLearningContainerRegistryCredentials(location, username, passwords?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningPasswordDetail"/>. </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns> A new <see cref="Models.MachineLearningPasswordDetail"/> instance for mocking. </returns>
        public static MachineLearningPasswordDetail MachineLearningPasswordDetail(string name = null, string value = null)
        {
            return new MachineLearningPasswordDetail(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningWorkspaceGetNotebookKeysResult"/>. </summary>
        /// <param name="primaryAccessKey"></param>
        /// <param name="secondaryAccessKey"></param>
        /// <returns> A new <see cref="Models.MachineLearningWorkspaceGetNotebookKeysResult"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceGetNotebookKeysResult MachineLearningWorkspaceGetNotebookKeysResult(string primaryAccessKey = null, string secondaryAccessKey = null)
        {
            return new MachineLearningWorkspaceGetNotebookKeysResult(primaryAccessKey, secondaryAccessKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningUsage"/>. </summary>
        /// <param name="id"> Specifies the resource ID. </param>
        /// <param name="amlWorkspaceLocation"> Region of the AML workspace in the id. </param>
        /// <param name="usageType"> Specifies the resource type. </param>
        /// <param name="unit"> An enum describing the unit of usage measurement. </param>
        /// <param name="currentValue"> The current usage of the resource. </param>
        /// <param name="limit"> The maximum permitted usage of the resource. </param>
        /// <param name="name"> The name of the type of usage. </param>
        /// <returns> A new <see cref="Models.MachineLearningUsage"/> instance for mocking. </returns>
        public static MachineLearningUsage MachineLearningUsage(string id = null, string amlWorkspaceLocation = null, string usageType = null, MachineLearningUsageUnit? unit = null, long? currentValue = null, long? limit = null, MachineLearningUsageName name = null)
        {
            return new MachineLearningUsage(
                id,
                amlWorkspaceLocation,
                usageType,
                unit,
                currentValue,
                limit,
                name,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningUsageName"/>. </summary>
        /// <param name="value"> The name of the resource. </param>
        /// <param name="localizedValue"> The localized name of the resource. </param>
        /// <returns> A new <see cref="Models.MachineLearningUsageName"/> instance for mocking. </returns>
        public static MachineLearningUsageName MachineLearningUsageName(string value = null, string localizedValue = null)
        {
            return new MachineLearningUsageName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningVmSize"/>. </summary>
        /// <param name="name"> The name of the virtual machine size. </param>
        /// <param name="family"> The family name of the virtual machine size. </param>
        /// <param name="vCpus"> The number of vCPUs supported by the virtual machine size. </param>
        /// <param name="gpus"> The number of gPUs supported by the virtual machine size. </param>
        /// <param name="osVhdSizeMB"> The OS VHD disk size, in MB, allowed by the virtual machine size. </param>
        /// <param name="maxResourceVolumeMB"> The resource volume size, in MB, allowed by the virtual machine size. </param>
        /// <param name="memoryGB"> The amount of memory, in GB, supported by the virtual machine size. </param>
        /// <param name="lowPriorityCapable"> Specifies if the virtual machine size supports low priority VMs. </param>
        /// <param name="isPremiumIOSupported"> Specifies if the virtual machine size supports premium IO. </param>
        /// <param name="estimatedVmPrices"> The estimated price information for using a VM. </param>
        /// <param name="supportedComputeTypes"> Specifies the compute types supported by the virtual machine size. </param>
        /// <returns> A new <see cref="Models.MachineLearningVmSize"/> instance for mocking. </returns>
        public static MachineLearningVmSize MachineLearningVmSize(string name = null, string family = null, int? vCpus = null, int? gpus = null, int? osVhdSizeMB = null, int? maxResourceVolumeMB = null, double? memoryGB = null, bool? lowPriorityCapable = null, bool? isPremiumIOSupported = null, MachineLearningEstimatedVmPrices estimatedVmPrices = null, IEnumerable<string> supportedComputeTypes = null)
        {
            supportedComputeTypes ??= new List<string>();

            return new MachineLearningVmSize(
                name,
                family,
                vCpus,
                gpus,
                osVhdSizeMB,
                maxResourceVolumeMB,
                memoryGB,
                lowPriorityCapable,
                isPremiumIOSupported,
                estimatedVmPrices,
                supportedComputeTypes?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningEstimatedVmPrices"/>. </summary>
        /// <param name="billingCurrency"> Three lettered code specifying the currency of the VM price. Example: USD. </param>
        /// <param name="unitOfMeasure"> The unit of time measurement for the specified VM price. Example: OneHour. </param>
        /// <param name="values"> The list of estimated prices for using a VM of a particular OS type, tier, etc. </param>
        /// <returns> A new <see cref="Models.MachineLearningEstimatedVmPrices"/> instance for mocking. </returns>
        public static MachineLearningEstimatedVmPrices MachineLearningEstimatedVmPrices(MachineLearningBillingCurrency billingCurrency = default, MachineLearningUnitOfMeasure unitOfMeasure = default, IEnumerable<MachineLearningEstimatedVmPrice> values = null)
        {
            values ??= new List<MachineLearningEstimatedVmPrice>();

            return new MachineLearningEstimatedVmPrices(billingCurrency, unitOfMeasure, values?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningEstimatedVmPrice"/>. </summary>
        /// <param name="retailPrice"> The price charged for using the VM. </param>
        /// <param name="osType"> Operating system type used by the VM. </param>
        /// <param name="vmTier"> The type of the VM. </param>
        /// <returns> A new <see cref="Models.MachineLearningEstimatedVmPrice"/> instance for mocking. </returns>
        public static MachineLearningEstimatedVmPrice MachineLearningEstimatedVmPrice(double retailPrice = default, MachineLearningVmPriceOSType osType = default, MachineLearningVmTier vmTier = default)
        {
            return new MachineLearningEstimatedVmPrice(retailPrice, osType, vmTier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningWorkspaceQuotaUpdate"/>. </summary>
        /// <param name="id"> Specifies the resource ID. </param>
        /// <param name="updateWorkspaceQuotasType"> Specifies the resource type. </param>
        /// <param name="limit"> The maximum permitted quota of the resource. </param>
        /// <param name="unit"> An enum describing the unit of quota measurement. </param>
        /// <param name="status"> Status of update workspace quota. </param>
        /// <returns> A new <see cref="Models.MachineLearningWorkspaceQuotaUpdate"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceQuotaUpdate MachineLearningWorkspaceQuotaUpdate(string id = null, string updateWorkspaceQuotasType = null, long? limit = null, MachineLearningQuotaUnit? unit = null, MachineLearningWorkspaceQuotaStatus? status = null)
        {
            return new MachineLearningWorkspaceQuotaUpdate(
                id,
                updateWorkspaceQuotasType,
                limit,
                unit,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningResourceQuota"/>. </summary>
        /// <param name="id"> Specifies the resource ID. </param>
        /// <param name="amlWorkspaceLocation"> Region of the AML workspace in the id. </param>
        /// <param name="resourceQuotaType"> Specifies the resource type. </param>
        /// <param name="name"> Name of the resource. </param>
        /// <param name="limit"> The maximum permitted quota of the resource. </param>
        /// <param name="unit"> An enum describing the unit of quota measurement. </param>
        /// <returns> A new <see cref="Models.MachineLearningResourceQuota"/> instance for mocking. </returns>
        public static MachineLearningResourceQuota MachineLearningResourceQuota(string id = null, string amlWorkspaceLocation = null, string resourceQuotaType = null, MachineLearningResourceName name = null, long? limit = null, MachineLearningQuotaUnit? unit = null)
        {
            return new MachineLearningResourceQuota(
                id,
                amlWorkspaceLocation,
                resourceQuotaType,
                name,
                limit,
                unit,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningResourceName"/>. </summary>
        /// <param name="value"> The name of the resource. </param>
        /// <param name="localizedValue"> The localized name of the resource. </param>
        /// <returns> A new <see cref="Models.MachineLearningResourceName"/> instance for mocking. </returns>
        public static MachineLearningResourceName MachineLearningResourceName(string value = null, string localizedValue = null)
        {
            return new MachineLearningResourceName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningComputeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="sku"> The sku of the workspace. </param>
        /// <param name="properties">
        /// Compute properties
        /// Please note <see cref="Models.MachineLearningComputeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MachineLearningAksCompute"/>, <see cref="Models.AmlCompute"/>, <see cref="Models.MachineLearningComputeInstance"/>, <see cref="Models.MachineLearningDatabricksCompute"/>, <see cref="Models.MachineLearningDataFactoryCompute"/>, <see cref="Models.MachineLearningDataLakeAnalytics"/>, <see cref="Models.MachineLearningHDInsightCompute"/>, <see cref="Models.MachineLearningKubernetesCompute"/>, <see cref="Models.MachineLearningSynapseSpark"/> and <see cref="Models.MachineLearningVirtualMachineCompute"/>.
        /// </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningComputeData"/> instance for mocking. </returns>
        public static MachineLearningComputeData MachineLearningComputeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, MachineLearningSku sku = null, MachineLearningComputeProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MachineLearningComputeData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                sku,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeProperties"/>. </summary>
        /// <param name="computeType"> The type of compute. </param>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeProperties"/> instance for mocking. </returns>
        public static MachineLearningComputeProperties MachineLearningComputeProperties(string computeType = null, string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new UnknownCompute(
                computeType == null ? default : new ComputeType(computeType),
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlComputeNodeInformation"/>. </summary>
        /// <param name="nodeId"> ID of the compute node. </param>
        /// <param name="privateIPAddress"> Private IP address of the compute node. </param>
        /// <param name="publicIPAddress"> Public IP address of the compute node. </param>
        /// <param name="port"> SSH port number of the node. </param>
        /// <param name="nodeState"> State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted. </param>
        /// <param name="runId"> ID of the Experiment running on the node, if any else null. </param>
        /// <returns> A new <see cref="Models.AmlComputeNodeInformation"/> instance for mocking. </returns>
        public static AmlComputeNodeInformation AmlComputeNodeInformation(string nodeId = null, IPAddress privateIPAddress = null, IPAddress publicIPAddress = null, int? port = null, MachineLearningNodeState? nodeState = null, string runId = null)
        {
            return new AmlComputeNodeInformation(
                nodeId,
                privateIPAddress,
                publicIPAddress,
                port,
                nodeState,
                runId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningWorkspaceNotebookAccessTokenResult"/>. </summary>
        /// <param name="notebookResourceId"></param>
        /// <param name="hostName"></param>
        /// <param name="publicDns"></param>
        /// <param name="accessToken"></param>
        /// <param name="tokenType"></param>
        /// <param name="expiresIn"></param>
        /// <param name="refreshToken"></param>
        /// <param name="scope"></param>
        /// <returns> A new <see cref="Models.MachineLearningWorkspaceNotebookAccessTokenResult"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceNotebookAccessTokenResult MachineLearningWorkspaceNotebookAccessTokenResult(string notebookResourceId = null, string hostName = null, string publicDns = null, string accessToken = null, string tokenType = null, int? expiresIn = null, string refreshToken = null, string scope = null)
        {
            return new MachineLearningWorkspaceNotebookAccessTokenResult(
                notebookResourceId,
                hostName,
                publicDns,
                accessToken,
                tokenType,
                expiresIn,
                refreshToken,
                scope,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningPrivateLinkResource"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="sku"> The sku of the workspace. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <returns> A new <see cref="Models.MachineLearningPrivateLinkResource"/> instance for mocking. </returns>
        public static MachineLearningPrivateLinkResource MachineLearningPrivateLinkResource(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, MachineLearningSku sku = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            tags ??= new Dictionary<string, string>();
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new MachineLearningPrivateLinkResource(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                sku,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningWorkspaceGetStorageAccountKeysResult"/>. </summary>
        /// <param name="userStorageKey"></param>
        /// <returns> A new <see cref="Models.MachineLearningWorkspaceGetStorageAccountKeysResult"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceGetStorageAccountKeysResult MachineLearningWorkspaceGetStorageAccountKeysResult(string userStorageKey = null)
        {
            return new MachineLearningWorkspaceGetStorageAccountKeysResult(userStorageKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningWorkspaceConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Please note <see cref="Models.MachineLearningWorkspaceConnectionProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AadAuthTypeWorkspaceConnectionProperties"/>, <see cref="Models.AccessKeyAuthTypeWorkspaceConnectionProperties"/>, <see cref="Models.AccountKeyAuthTypeWorkspaceConnectionProperties"/>, <see cref="Models.ApiKeyAuthWorkspaceConnectionProperties"/>, <see cref="Models.CustomKeysWorkspaceConnectionProperties"/>, <see cref="Models.MachineLearningManagedIdentityAuthTypeWorkspaceConnection"/>, <see cref="Models.MachineLearningNoneAuthTypeWorkspaceConnection"/>, <see cref="Models.OAuth2AuthTypeWorkspaceConnectionProperties"/>, <see cref="Models.MachineLearningPatAuthTypeWorkspaceConnection"/>, <see cref="Models.MachineLearningSasAuthTypeWorkspaceConnection"/>, <see cref="Models.ServicePrincipalAuthTypeWorkspaceConnectionProperties"/> and <see cref="Models.MachineLearningUsernamePasswordAuthTypeWorkspaceConnection"/>.
        /// </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningWorkspaceConnectionData"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceConnectionData MachineLearningWorkspaceConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningWorkspaceConnectionProperties properties = null)
        {
            return new MachineLearningWorkspaceConnectionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningWorkspaceConnectionProperties"/>. </summary>
        /// <param name="authType"> Authentication type of the connection target. </param>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <returns> A new <see cref="Models.MachineLearningWorkspaceConnectionProperties"/> instance for mocking. </returns>
        public static MachineLearningWorkspaceConnectionProperties MachineLearningWorkspaceConnectionProperties(string authType = null, MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new UnknownWorkspaceConnectionPropertiesV2(
                authType == null ? default : new MachineLearningConnectionAuthType(authType),
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningFqdnEndpoints"/>. </summary>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="Models.MachineLearningFqdnEndpoints"/> instance for mocking. </returns>
        public static MachineLearningFqdnEndpoints MachineLearningFqdnEndpoints(MachineLearningFqdnEndpointsProperties properties = null)
        {
            return new MachineLearningFqdnEndpoints(properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningFqdnEndpointsProperties"/>. </summary>
        /// <param name="category"></param>
        /// <param name="endpoints"></param>
        /// <returns> A new <see cref="Models.MachineLearningFqdnEndpointsProperties"/> instance for mocking. </returns>
        public static MachineLearningFqdnEndpointsProperties MachineLearningFqdnEndpointsProperties(string category = null, IEnumerable<MachineLearningFqdnEndpoint> endpoints = null)
        {
            endpoints ??= new List<MachineLearningFqdnEndpoint>();

            return new MachineLearningFqdnEndpointsProperties(category, endpoints?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningFqdnEndpoint"/>. </summary>
        /// <param name="domainName"></param>
        /// <param name="endpointDetails"></param>
        /// <returns> A new <see cref="Models.MachineLearningFqdnEndpoint"/> instance for mocking. </returns>
        public static MachineLearningFqdnEndpoint MachineLearningFqdnEndpoint(string domainName = null, IEnumerable<MachineLearningFqdnEndpointDetail> endpointDetails = null)
        {
            endpointDetails ??= new List<MachineLearningFqdnEndpointDetail>();

            return new MachineLearningFqdnEndpoint(domainName, endpointDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningFqdnEndpointDetail"/>. </summary>
        /// <param name="port"></param>
        /// <returns> A new <see cref="Models.MachineLearningFqdnEndpointDetail"/> instance for mocking. </returns>
        public static MachineLearningFqdnEndpointDetail MachineLearningFqdnEndpointDetail(int? port = null)
        {
            return new MachineLearningFqdnEndpointDetail(port, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningOutboundRuleBasicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Outbound Rule for the managed network of a machine learning workspace.
        /// Please note <see cref="MachineLearningOutboundRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FqdnOutboundRule"/>, <see cref="PrivateEndpointOutboundRule"/> and <see cref="ServiceTagOutboundRule"/>.
        /// </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningOutboundRuleBasicData"/> instance for mocking. </returns>
        public static MachineLearningOutboundRuleBasicData MachineLearningOutboundRuleBasicData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningOutboundRule properties = null)
        {
            return new MachineLearningOutboundRuleBasicData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningCodeContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningCodeContainerData"/> instance for mocking. </returns>
        public static MachineLearningCodeContainerData MachineLearningCodeContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningCodeContainerProperties properties = null)
        {
            return new MachineLearningCodeContainerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningCodeContainerProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="latestVersion"> The latest version inside this container. </param>
        /// <param name="nextVersion"> The next auto incremental version. </param>
        /// <param name="provisioningState"> Provisioning state for the code container. </param>
        /// <returns> A new <see cref="Models.MachineLearningCodeContainerProperties"/> instance for mocking. </returns>
        public static MachineLearningCodeContainerProperties MachineLearningCodeContainerProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, string latestVersion = null, string nextVersion = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningCodeContainerProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                latestVersion,
                nextVersion,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningAssetContainer"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="latestVersion"> The latest version inside this container. </param>
        /// <param name="nextVersion"> The next auto incremental version. </param>
        /// <returns> A new <see cref="Models.MachineLearningAssetContainer"/> instance for mocking. </returns>
        public static MachineLearningAssetContainer MachineLearningAssetContainer(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, string latestVersion = null, string nextVersion = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningAssetContainer(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                latestVersion,
                nextVersion);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningCodeVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningCodeVersionData"/> instance for mocking. </returns>
        public static MachineLearningCodeVersionData MachineLearningCodeVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningCodeVersionProperties properties = null)
        {
            return new MachineLearningCodeVersionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningCodeVersionProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="isAnonymous"> If the name version are system generated (anonymous registration). </param>
        /// <param name="codeUri"> Uri where code is located. </param>
        /// <param name="provisioningState"> Provisioning state for the code version. </param>
        /// <returns> A new <see cref="Models.MachineLearningCodeVersionProperties"/> instance for mocking. </returns>
        public static MachineLearningCodeVersionProperties MachineLearningCodeVersionProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, bool? isAnonymous = null, Uri codeUri = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningCodeVersionProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                isAnonymous,
                codeUri,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PendingUploadResponseDto"/>. </summary>
        /// <param name="blobReferenceForConsumption"> Container level read, write, list SAS. </param>
        /// <param name="pendingUploadId"> ID for this upload request. </param>
        /// <param name="pendingUploadType"> TemporaryBlobReference is the only supported type. </param>
        /// <returns> A new <see cref="Models.PendingUploadResponseDto"/> instance for mocking. </returns>
        public static PendingUploadResponseDto PendingUploadResponseDto(BlobReferenceForConsumptionDto blobReferenceForConsumption = null, string pendingUploadId = null, PendingUploadType? pendingUploadType = null)
        {
            return new PendingUploadResponseDto(blobReferenceForConsumption, pendingUploadId, pendingUploadType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobReferenceForConsumptionDto"/>. </summary>
        /// <param name="blobUri">
        /// Blob URI path for client to upload data.
        /// Example: https://blob.windows.core.net/Container/Path
        /// </param>
        /// <param name="storageAccountArmId"> Arm ID of the storage account to use. </param>
        /// <param name="credential">
        /// Credential info to access storage account
        /// Please note <see cref="PendingUploadCredentialDto"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.SasCredentialDto"/>.
        /// </param>
        /// <returns> A new <see cref="Models.BlobReferenceForConsumptionDto"/> instance for mocking. </returns>
        public static BlobReferenceForConsumptionDto BlobReferenceForConsumptionDto(Uri blobUri = null, ResourceIdentifier storageAccountArmId = null, PendingUploadCredentialDto credential = null)
        {
            return new BlobReferenceForConsumptionDto(blobUri, storageAccountArmId, credential, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningComponentContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningComponentContainerData"/> instance for mocking. </returns>
        public static MachineLearningComponentContainerData MachineLearningComponentContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningComponentContainerProperties properties = null)
        {
            return new MachineLearningComponentContainerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComponentContainerProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="latestVersion"> The latest version inside this container. </param>
        /// <param name="nextVersion"> The next auto incremental version. </param>
        /// <param name="provisioningState"> Provisioning state for the component container. </param>
        /// <returns> A new <see cref="Models.MachineLearningComponentContainerProperties"/> instance for mocking. </returns>
        public static MachineLearningComponentContainerProperties MachineLearningComponentContainerProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, string latestVersion = null, string nextVersion = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningComponentContainerProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                latestVersion,
                nextVersion,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningComponentVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningComponentVersionData"/> instance for mocking. </returns>
        public static MachineLearningComponentVersionData MachineLearningComponentVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningComponentVersionProperties properties = null)
        {
            return new MachineLearningComponentVersionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComponentVersionProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="isAnonymous"> If the name version are system generated (anonymous registration). </param>
        /// <param name="componentSpec">
        /// Defines Component definition details.
        /// &lt;see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" /&gt;
        /// </param>
        /// <param name="provisioningState"> Provisioning state for the component version. </param>
        /// <returns> A new <see cref="Models.MachineLearningComponentVersionProperties"/> instance for mocking. </returns>
        public static MachineLearningComponentVersionProperties MachineLearningComponentVersionProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, bool? isAnonymous = null, BinaryData componentSpec = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningComponentVersionProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                isAnonymous,
                componentSpec,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningDataContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningDataContainerData"/> instance for mocking. </returns>
        public static MachineLearningDataContainerData MachineLearningDataContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningDataContainerProperties properties = null)
        {
            return new MachineLearningDataContainerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDataContainerProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="latestVersion"> The latest version inside this container. </param>
        /// <param name="nextVersion"> The next auto incremental version. </param>
        /// <param name="dataType"> [Required] Specifies the type of data. </param>
        /// <returns> A new <see cref="Models.MachineLearningDataContainerProperties"/> instance for mocking. </returns>
        public static MachineLearningDataContainerProperties MachineLearningDataContainerProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, string latestVersion = null, string nextVersion = null, MachineLearningDataType dataType = default)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningDataContainerProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                latestVersion,
                nextVersion,
                dataType);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningDataVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// [Required] Additional attributes of the entity.
        /// Please note <see cref="MachineLearningDataVersionProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningTable"/>, <see cref="MachineLearningUriFileDataVersion"/> and <see cref="MachineLearningUriFolderDataVersion"/>.
        /// </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningDataVersionData"/> instance for mocking. </returns>
        public static MachineLearningDataVersionData MachineLearningDataVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningDataVersionProperties properties = null)
        {
            return new MachineLearningDataVersionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobReferenceSasResult"/>. </summary>
        /// <param name="blobReferenceForConsumption"> Blob reference for consumption details. </param>
        /// <returns> A new <see cref="Models.BlobReferenceSasResult"/> instance for mocking. </returns>
        public static BlobReferenceSasResult BlobReferenceSasResult(GetBlobReferenceForConsumptionDto blobReferenceForConsumption = null)
        {
            return new BlobReferenceSasResult(blobReferenceForConsumption, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetBlobReferenceForConsumptionDto"/>. </summary>
        /// <param name="blobUri"> Blob uri, example: https://blob.windows.core.net/Container/Path. </param>
        /// <param name="storageAccountArmId"> The ARM id of the storage account. </param>
        /// <param name="credential">
        /// Credential info to access storage account
        /// Please note <see cref="DataReferenceCredential"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DockerCredential"/>, <see cref="Models.ManagedIdentityCredential"/>, <see cref="AnonymousAccessCredential"/> and <see cref="Models.SasCredential"/>.
        /// </param>
        /// <returns> A new <see cref="Models.GetBlobReferenceForConsumptionDto"/> instance for mocking. </returns>
        public static GetBlobReferenceForConsumptionDto GetBlobReferenceForConsumptionDto(Uri blobUri = null, string storageAccountArmId = null, DataReferenceCredential credential = null)
        {
            return new GetBlobReferenceForConsumptionDto(blobUri, storageAccountArmId, credential, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningEnvironmentContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningEnvironmentContainerData"/> instance for mocking. </returns>
        public static MachineLearningEnvironmentContainerData MachineLearningEnvironmentContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningEnvironmentContainerProperties properties = null)
        {
            return new MachineLearningEnvironmentContainerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningEnvironmentContainerProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="latestVersion"> The latest version inside this container. </param>
        /// <param name="nextVersion"> The next auto incremental version. </param>
        /// <param name="provisioningState"> Provisioning state for the environment container. </param>
        /// <returns> A new <see cref="Models.MachineLearningEnvironmentContainerProperties"/> instance for mocking. </returns>
        public static MachineLearningEnvironmentContainerProperties MachineLearningEnvironmentContainerProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, string latestVersion = null, string nextVersion = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningEnvironmentContainerProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                latestVersion,
                nextVersion,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningEnvironmentVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningEnvironmentVersionData"/> instance for mocking. </returns>
        public static MachineLearningEnvironmentVersionData MachineLearningEnvironmentVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningEnvironmentVersionProperties properties = null)
        {
            return new MachineLearningEnvironmentVersionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningEnvironmentVersionProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="isAnonymous"> If the name version are system generated (anonymous registration). </param>
        /// <param name="environmentType">
        /// Environment type is either user managed or curated by the Azure ML service
        /// &lt;see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" /&gt;
        /// </param>
        /// <param name="image">
        /// Name of the image that will be used for the environment.
        /// &lt;seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" /&gt;
        /// </param>
        /// <param name="condaFile">
        /// Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
        /// &lt;see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" /&gt;
        /// </param>
        /// <param name="build"> Configuration settings for Docker build context. </param>
        /// <param name="osType"> The OS type of the environment. </param>
        /// <param name="inferenceConfig"> Defines configuration specific to inference. </param>
        /// <param name="autoRebuild"> Defines if image needs to be rebuilt based on base image changes. </param>
        /// <param name="provisioningState"> Provisioning state for the environment version. </param>
        /// <param name="stage"> Stage in the environment lifecycle assigned to this environment. </param>
        /// <returns> A new <see cref="Models.MachineLearningEnvironmentVersionProperties"/> instance for mocking. </returns>
        public static MachineLearningEnvironmentVersionProperties MachineLearningEnvironmentVersionProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, bool? isAnonymous = null, MachineLearningEnvironmentType? environmentType = null, string image = null, string condaFile = null, MachineLearningBuildContext build = null, MachineLearningOperatingSystemType? osType = null, MachineLearningInferenceContainerProperties inferenceConfig = null, AutoRebuildSetting? autoRebuild = null, RegistryAssetProvisioningState? provisioningState = null, string stage = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningEnvironmentVersionProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                isAnonymous,
                environmentType,
                image,
                condaFile,
                build,
                osType,
                inferenceConfig,
                autoRebuild,
                provisioningState,
                stage);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningModelContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningModelContainerData"/> instance for mocking. </returns>
        public static MachineLearningModelContainerData MachineLearningModelContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningModelContainerProperties properties = null)
        {
            return new MachineLearningModelContainerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningModelContainerProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="latestVersion"> The latest version inside this container. </param>
        /// <param name="nextVersion"> The next auto incremental version. </param>
        /// <param name="provisioningState"> Provisioning state for the model container. </param>
        /// <returns> A new <see cref="Models.MachineLearningModelContainerProperties"/> instance for mocking. </returns>
        public static MachineLearningModelContainerProperties MachineLearningModelContainerProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, string latestVersion = null, string nextVersion = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningModelContainerProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                latestVersion,
                nextVersion,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningModelVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningModelVersionData"/> instance for mocking. </returns>
        public static MachineLearningModelVersionData MachineLearningModelVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningModelVersionProperties properties = null)
        {
            return new MachineLearningModelVersionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningModelVersionProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="isAnonymous"> If the name version are system generated (anonymous registration). </param>
        /// <param name="flavors"> Mapping of model flavors to their properties. </param>
        /// <param name="modelType"> The storage format for this entity. Used for NCD. </param>
        /// <param name="modelUri"> The URI path to the model contents. </param>
        /// <param name="jobName"> Name of the training job which produced this model. </param>
        /// <param name="provisioningState"> Provisioning state for the model version. </param>
        /// <param name="stage"> Stage in the model lifecycle assigned to this model. </param>
        /// <returns> A new <see cref="Models.MachineLearningModelVersionProperties"/> instance for mocking. </returns>
        public static MachineLearningModelVersionProperties MachineLearningModelVersionProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, bool? isAnonymous = null, IDictionary<string, MachineLearningFlavorData> flavors = null, string modelType = null, Uri modelUri = null, string jobName = null, RegistryAssetProvisioningState? provisioningState = null, string stage = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            flavors ??= new Dictionary<string, MachineLearningFlavorData>();

            return new MachineLearningModelVersionProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                isAnonymous,
                flavors,
                modelType,
                modelUri,
                jobName,
                provisioningState,
                stage);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningBatchEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <param name="kind"> Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="sku"> Sku details required for ARM contract for Autoscaling. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningBatchEndpointData"/> instance for mocking. </returns>
        public static MachineLearningBatchEndpointData MachineLearningBatchEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, MachineLearningBatchEndpointProperties properties = null, string kind = null, ManagedServiceIdentity identity = null, MachineLearningSku sku = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MachineLearningBatchEndpointData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                kind,
                identity,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningBatchEndpointProperties"/>. </summary>
        /// <param name="description"> Description of the inference endpoint. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="scoringUri"> Endpoint URI. </param>
        /// <param name="swaggerUri"> Endpoint Swagger URI. </param>
        /// <param name="authMode"> [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does. </param>
        /// <param name="keys">
        /// EndpointAuthKeys to set initially on an Endpoint.
        /// This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        /// </param>
        /// <param name="defaultsDeploymentName"> Default values for Batch Endpoint. </param>
        /// <param name="provisioningState"> Provisioning state for the endpoint. </param>
        /// <returns> A new <see cref="Models.MachineLearningBatchEndpointProperties"/> instance for mocking. </returns>
        public static MachineLearningBatchEndpointProperties MachineLearningBatchEndpointProperties(string description = null, IDictionary<string, string> properties = null, Uri scoringUri = null, Uri swaggerUri = null, MachineLearningEndpointAuthMode authMode = default, MachineLearningEndpointAuthKeys keys = null, string defaultsDeploymentName = null, MachineLearningEndpointProvisioningState? provisioningState = null)
        {
            properties ??= new Dictionary<string, string>();

            return new MachineLearningBatchEndpointProperties(
                description,
                properties,
                scoringUri,
                swaggerUri,
                authMode,
                keys,
                serializedAdditionalRawData: null,
                defaultsDeploymentName != null ? new BatchEndpointDefaults(defaultsDeploymentName, serializedAdditionalRawData: null) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningEndpointProperties"/>. </summary>
        /// <param name="description"> Description of the inference endpoint. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="scoringUri"> Endpoint URI. </param>
        /// <param name="swaggerUri"> Endpoint Swagger URI. </param>
        /// <param name="authMode"> [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does. </param>
        /// <param name="keys">
        /// EndpointAuthKeys to set initially on an Endpoint.
        /// This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        /// </param>
        /// <returns> A new <see cref="Models.MachineLearningEndpointProperties"/> instance for mocking. </returns>
        public static MachineLearningEndpointProperties MachineLearningEndpointProperties(string description = null, IDictionary<string, string> properties = null, Uri scoringUri = null, Uri swaggerUri = null, MachineLearningEndpointAuthMode authMode = default, MachineLearningEndpointAuthKeys keys = null)
        {
            properties ??= new Dictionary<string, string>();

            return new MachineLearningEndpointProperties(
                description,
                properties,
                scoringUri,
                swaggerUri,
                authMode,
                keys,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningBatchDeploymentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <param name="kind"> Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="sku"> Sku details required for ARM contract for Autoscaling. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningBatchDeploymentData"/> instance for mocking. </returns>
        public static MachineLearningBatchDeploymentData MachineLearningBatchDeploymentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, MachineLearningBatchDeploymentProperties properties = null, string kind = null, ManagedServiceIdentity identity = null, MachineLearningSku sku = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MachineLearningBatchDeploymentData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                kind,
                identity,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningBatchDeploymentProperties"/>. </summary>
        /// <param name="description"> Description of the endpoint deployment. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="codeConfiguration"> Code configuration for the endpoint deployment. </param>
        /// <param name="environmentId"> ARM resource ID or AssetId of the environment specification for the endpoint deployment. </param>
        /// <param name="environmentVariables"> Environment variables configuration for the deployment. </param>
        /// <param name="compute"> Compute target for batch inference operation. </param>
        /// <param name="deploymentConfiguration">
        /// Properties relevant to different deployment types.
        /// Please note <see cref="BatchDeploymentConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BatchPipelineComponentDeploymentConfiguration"/>.
        /// </param>
        /// <param name="errorThreshold">
        /// Error threshold, if the error count for the entire input goes above this value,
        /// the batch inference will be aborted. Range is [-1, int.MaxValue].
        /// For FileDataset, this value is the count of file failures.
        /// For TabularDataset, this value is the count of record failures.
        /// If set to -1 (the lower bound), all failures during batch inference will be ignored.
        /// </param>
        /// <param name="retrySettings">
        /// Retry Settings for the batch inference operation.
        /// If not provided, will default to the defaults defined in BatchRetrySettings.
        /// </param>
        /// <param name="miniBatchSize">
        /// Size of the mini-batch passed to each batch invocation.
        /// For FileDataset, this is the number of files per mini-batch.
        /// For TabularDataset, this is the size of the records in bytes, per mini-batch.
        /// </param>
        /// <param name="loggingLevel"> Logging level for batch inference operation. </param>
        /// <param name="model">
        /// Reference to the model asset for the endpoint deployment.
        /// Please note <see cref="MachineLearningAssetReferenceBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningDataPathAssetReference"/>, <see cref="MachineLearningIdAssetReference"/> and <see cref="MachineLearningOutputPathAssetReference"/>.
        /// </param>
        /// <param name="maxConcurrencyPerInstance"> Indicates maximum number of parallelism per instance. </param>
        /// <param name="outputAction"> Indicates how the output will be organized. </param>
        /// <param name="outputFileName"> Customized output file name for append_row output action. </param>
        /// <param name="resources">
        /// Indicates compute configuration for the job.
        /// If not provided, will default to the defaults defined in ResourceConfiguration.
        /// </param>
        /// <param name="provisioningState"> Provisioning state for the endpoint deployment. </param>
        /// <returns> A new <see cref="Models.MachineLearningBatchDeploymentProperties"/> instance for mocking. </returns>
        public static MachineLearningBatchDeploymentProperties MachineLearningBatchDeploymentProperties(string description = null, IDictionary<string, string> properties = null, MachineLearningCodeConfiguration codeConfiguration = null, string environmentId = null, IDictionary<string, string> environmentVariables = null, string compute = null, BatchDeploymentConfiguration deploymentConfiguration = null, int? errorThreshold = null, MachineLearningBatchRetrySettings retrySettings = null, long? miniBatchSize = null, MachineLearningBatchLoggingLevel? loggingLevel = null, MachineLearningAssetReferenceBase model = null, int? maxConcurrencyPerInstance = null, MachineLearningBatchOutputAction? outputAction = null, string outputFileName = null, MachineLearningDeploymentResourceConfiguration resources = null, MachineLearningDeploymentProvisioningState? provisioningState = null)
        {
            properties ??= new Dictionary<string, string>();
            environmentVariables ??= new Dictionary<string, string>();

            return new MachineLearningBatchDeploymentProperties(
                description,
                properties,
                codeConfiguration,
                environmentId,
                environmentVariables,
                serializedAdditionalRawData: null,
                compute,
                deploymentConfiguration,
                errorThreshold,
                retrySettings,
                miniBatchSize,
                loggingLevel,
                model,
                maxConcurrencyPerInstance,
                outputAction,
                outputFileName,
                resources,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningDatastoreData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// [Required] Additional attributes of the entity.
        /// Please note <see cref="Models.MachineLearningDatastoreProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MachineLearningAzureBlobDatastore"/>, <see cref="Models.MachineLearningAzureDataLakeGen1Datastore"/>, <see cref="Models.MachineLearningAzureDataLakeGen2Datastore"/>, <see cref="Models.MachineLearningAzureFileDatastore"/> and <see cref="Models.OneLakeDatastore"/>.
        /// </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningDatastoreData"/> instance for mocking. </returns>
        public static MachineLearningDatastoreData MachineLearningDatastoreData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningDatastoreProperties properties = null)
        {
            return new MachineLearningDatastoreData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDatastoreProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="datastoreType"> [Required] Storage type backing the datastore. </param>
        /// <param name="isDefault"> Readonly property to indicate if datastore is the workspace default datastore. </param>
        /// <param name="credentials">
        /// [Required] Account credentials.
        /// Please note <see cref="MachineLearningDatastoreCredentials"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningAccountKeyDatastoreCredentials"/>, <see cref="MachineLearningCertificateDatastoreCredentials"/>, <see cref="MachineLearningNoneDatastoreCredentials"/>, <see cref="MachineLearningSasDatastoreCredentials"/> and <see cref="MachineLearningServicePrincipalDatastoreCredentials"/>.
        /// </param>
        /// <returns> A new <see cref="Models.MachineLearningDatastoreProperties"/> instance for mocking. </returns>
        public static MachineLearningDatastoreProperties MachineLearningDatastoreProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, string datastoreType = null, bool? isDefault = null, MachineLearningDatastoreCredentials credentials = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningDatastoreProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                datastoreType == null ? default : new DatastoreType(datastoreType),
                isDefault,
                credentials);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningFeatureSetContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningFeatureSetContainerData"/> instance for mocking. </returns>
        public static MachineLearningFeatureSetContainerData MachineLearningFeatureSetContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningFeatureSetContainerProperties properties = null)
        {
            return new MachineLearningFeatureSetContainerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningFeatureSetContainerProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="latestVersion"> The latest version inside this container. </param>
        /// <param name="nextVersion"> The next auto incremental version. </param>
        /// <param name="provisioningState"> Provisioning state for the featureset container. </param>
        /// <returns> A new <see cref="Models.MachineLearningFeatureSetContainerProperties"/> instance for mocking. </returns>
        public static MachineLearningFeatureSetContainerProperties MachineLearningFeatureSetContainerProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, string latestVersion = null, string nextVersion = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningFeatureSetContainerProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                latestVersion,
                nextVersion,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningFeatureData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningFeatureData"/> instance for mocking. </returns>
        public static MachineLearningFeatureData MachineLearningFeatureData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningFeatureProperties properties = null)
        {
            return new MachineLearningFeatureData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningFeatureSetVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningFeatureSetVersionData"/> instance for mocking. </returns>
        public static MachineLearningFeatureSetVersionData MachineLearningFeatureSetVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningFeatureSetVersionProperties properties = null)
        {
            return new MachineLearningFeatureSetVersionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningFeatureSetVersionProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="isAnonymous"> If the name version are system generated (anonymous registration). </param>
        /// <param name="specificationPath"> Specifies the feature spec details. </param>
        /// <param name="materializationSettings"> Specifies the materialization settings. </param>
        /// <param name="stage"> Specifies the asset stage. </param>
        /// <param name="entities"> Specifies list of entities. </param>
        /// <param name="provisioningState"> Provisioning state for the featureset version container. </param>
        /// <returns> A new <see cref="Models.MachineLearningFeatureSetVersionProperties"/> instance for mocking. </returns>
        public static MachineLearningFeatureSetVersionProperties MachineLearningFeatureSetVersionProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, bool? isAnonymous = null, string specificationPath = null, MaterializationSettings materializationSettings = null, string stage = null, IEnumerable<string> entities = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            entities ??= new List<string>();

            return new MachineLearningFeatureSetVersionProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                isAnonymous,
                specificationPath != null ? new FeaturesetSpecification(specificationPath, serializedAdditionalRawData: null) : null,
                materializationSettings,
                stage,
                entities?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FeaturesetVersionBackfillResponse"/>. </summary>
        /// <param name="jobIds"> List of jobs submitted as part of the backfill request. </param>
        /// <returns> A new <see cref="Models.FeaturesetVersionBackfillResponse"/> instance for mocking. </returns>
        public static FeaturesetVersionBackfillResponse FeaturesetVersionBackfillResponse(IEnumerable<string> jobIds = null)
        {
            jobIds ??= new List<string>();

            return new FeaturesetVersionBackfillResponse(jobIds?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningFeatureStoreEntityContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningFeatureStoreEntityContainerData"/> instance for mocking. </returns>
        public static MachineLearningFeatureStoreEntityContainerData MachineLearningFeatureStoreEntityContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningFeatureStoreEntityContainerProperties properties = null)
        {
            return new MachineLearningFeatureStoreEntityContainerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningFeatureStoreEntityContainerProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="latestVersion"> The latest version inside this container. </param>
        /// <param name="nextVersion"> The next auto incremental version. </param>
        /// <param name="provisioningState"> Provisioning state for the featurestore entity container. </param>
        /// <returns> A new <see cref="Models.MachineLearningFeatureStoreEntityContainerProperties"/> instance for mocking. </returns>
        public static MachineLearningFeatureStoreEntityContainerProperties MachineLearningFeatureStoreEntityContainerProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, string latestVersion = null, string nextVersion = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningFeatureStoreEntityContainerProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                latestVersion,
                nextVersion,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningFeaturestoreEntityVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningFeaturestoreEntityVersionData"/> instance for mocking. </returns>
        public static MachineLearningFeaturestoreEntityVersionData MachineLearningFeaturestoreEntityVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningFeatureStoreEntityVersionProperties properties = null)
        {
            return new MachineLearningFeaturestoreEntityVersionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningFeatureStoreEntityVersionProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="isAnonymous"> If the name version are system generated (anonymous registration). </param>
        /// <param name="indexColumns"> Specifies index columns. </param>
        /// <param name="stage"> Specifies the asset stage. </param>
        /// <param name="provisioningState"> Provisioning state for the featurestore entity version. </param>
        /// <returns> A new <see cref="Models.MachineLearningFeatureStoreEntityVersionProperties"/> instance for mocking. </returns>
        public static MachineLearningFeatureStoreEntityVersionProperties MachineLearningFeatureStoreEntityVersionProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isArchived = null, bool? isAnonymous = null, IEnumerable<IndexColumn> indexColumns = null, string stage = null, RegistryAssetProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            indexColumns ??= new List<IndexColumn>();

            return new MachineLearningFeatureStoreEntityVersionProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                isArchived,
                isAnonymous,
                indexColumns?.ToList(),
                stage,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// [Required] Additional attributes of the entity.
        /// Please note <see cref="Models.MachineLearningJobProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AutoMLJob"/>, <see cref="Models.MachineLearningCommandJob"/>, <see cref="Models.MachineLearningPipelineJob"/>, <see cref="Models.SparkJob"/> and <see cref="Models.MachineLearningSweepJob"/>.
        /// </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningJobData"/> instance for mocking. </returns>
        public static MachineLearningJobData MachineLearningJobData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningJobProperties properties = null)
        {
            return new MachineLearningJobData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningJobProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="jobType"> [Required] Specifies the type of job. </param>
        /// <param name="displayName"> Display name of job. </param>
        /// <param name="status"> Status of the job. </param>
        /// <param name="experimentName"> The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment. </param>
        /// <param name="services">
        /// List of JobEndpoints.
        /// For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        /// </param>
        /// <param name="computeId"> ARM resource ID of the compute resource. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="identity">
        /// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        /// Defaults to AmlToken if null.
        /// Please note <see cref="MachineLearningIdentityConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmlToken"/>, <see cref="MachineLearningManagedIdentity"/> and <see cref="MachineLearningUserIdentity"/>.
        /// </param>
        /// <param name="componentId"> ARM resource ID of the component resource. </param>
        /// <param name="notificationSetting"> Notification setting for the job. </param>
        /// <returns> A new <see cref="Models.MachineLearningJobProperties"/> instance for mocking. </returns>
        public static MachineLearningJobProperties MachineLearningJobProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, string jobType = null, string displayName = null, MachineLearningJobStatus? status = null, string experimentName = null, IDictionary<string, MachineLearningJobService> services = null, ResourceIdentifier computeId = null, bool? isArchived = null, MachineLearningIdentityConfiguration identity = null, ResourceIdentifier componentId = null, NotificationSetting notificationSetting = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            services ??= new Dictionary<string, MachineLearningJobService>();

            return new MachineLearningJobProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                jobType == null ? default : new JobType(jobType),
                displayName,
                status,
                experimentName,
                services,
                computeId,
                isArchived,
                identity,
                componentId,
                notificationSetting);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningJobService"/>. </summary>
        /// <param name="jobServiceType"> Endpoint type. </param>
        /// <param name="port"> Port for endpoint. </param>
        /// <param name="endpoint"> Url for endpoint. </param>
        /// <param name="status"> Status of endpoint. </param>
        /// <param name="errorMessage"> Any error in the service. </param>
        /// <param name="properties"> Additional properties to set on the endpoint. </param>
        /// <param name="nodes">
        /// Nodes that user would like to start the service on.
        /// If Nodes is not set or set to null, the service will only be started on leader node.
        /// Please note <see cref="JobNodes"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="JobAllNodes"/>.
        /// </param>
        /// <returns> A new <see cref="Models.MachineLearningJobService"/> instance for mocking. </returns>
        public static MachineLearningJobService MachineLearningJobService(string jobServiceType = null, int? port = null, string endpoint = null, string status = null, string errorMessage = null, IDictionary<string, string> properties = null, JobNodes nodes = null)
        {
            properties ??= new Dictionary<string, string>();

            return new MachineLearningJobService(
                jobServiceType,
                port,
                endpoint,
                status,
                errorMessage,
                properties,
                nodes,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningMarketplaceSubscriptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningMarketplaceSubscriptionData"/> instance for mocking. </returns>
        public static MachineLearningMarketplaceSubscriptionData MachineLearningMarketplaceSubscriptionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningMarketplaceSubscriptionProperties properties = null)
        {
            return new MachineLearningMarketplaceSubscriptionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningMarketplaceSubscriptionProperties"/>. </summary>
        /// <param name="modelId"> [Required] Target Marketplace Model ID to create a Marketplace Subscription for. </param>
        /// <param name="marketplacePlan"> Marketplace Plan associated with the Marketplace Subscription. </param>
        /// <param name="marketplaceSubscriptionStatus"> Current status of the Marketplace Subscription. </param>
        /// <param name="provisioningState"> Provisioning State of the Marketplace Subscription. </param>
        /// <returns> A new <see cref="Models.MachineLearningMarketplaceSubscriptionProperties"/> instance for mocking. </returns>
        public static MachineLearningMarketplaceSubscriptionProperties MachineLearningMarketplaceSubscriptionProperties(string modelId = null, MachineLearningMarketplacePlan marketplacePlan = null, MarketplaceSubscriptionStatus? marketplaceSubscriptionStatus = null, MarketplaceSubscriptionProvisioningState? provisioningState = null)
        {
            return new MachineLearningMarketplaceSubscriptionProperties(modelId, marketplacePlan, marketplaceSubscriptionStatus, provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningMarketplacePlan"/>. </summary>
        /// <param name="publisherId"> The identifying name of the Publisher of the Marketplace Plan. </param>
        /// <param name="offerId"> The identifying name of the Offer of the Marketplace Plan. </param>
        /// <param name="planId"> The identifying name of the Plan of the Marketplace Plan. </param>
        /// <returns> A new <see cref="Models.MachineLearningMarketplacePlan"/> instance for mocking. </returns>
        public static MachineLearningMarketplacePlan MachineLearningMarketplacePlan(string publisherId = null, string offerId = null, string planId = null)
        {
            return new MachineLearningMarketplacePlan(publisherId, offerId, planId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningOnlineEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <param name="kind"> Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="sku"> Sku details required for ARM contract for Autoscaling. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningOnlineEndpointData"/> instance for mocking. </returns>
        public static MachineLearningOnlineEndpointData MachineLearningOnlineEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, MachineLearningOnlineEndpointProperties properties = null, string kind = null, ManagedServiceIdentity identity = null, MachineLearningSku sku = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MachineLearningOnlineEndpointData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                kind,
                identity,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningOnlineEndpointProperties"/>. </summary>
        /// <param name="description"> Description of the inference endpoint. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="scoringUri"> Endpoint URI. </param>
        /// <param name="swaggerUri"> Endpoint Swagger URI. </param>
        /// <param name="authMode"> [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does. </param>
        /// <param name="keys">
        /// EndpointAuthKeys to set initially on an Endpoint.
        /// This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        /// </param>
        /// <param name="provisioningState"> Provisioning state for the endpoint. </param>
        /// <param name="compute">
        /// ARM resource ID of the compute if it exists.
        /// optional
        /// </param>
        /// <param name="publicNetworkAccess"> Set to "Enabled" for endpoints that should allow public access when Private Link is enabled. </param>
        /// <param name="traffic"> Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100. </param>
        /// <param name="mirrorTraffic"> Percentage of traffic to be mirrored to each deployment without using returned scoring. Traffic values need to sum to utmost 50. </param>
        /// <returns> A new <see cref="Models.MachineLearningOnlineEndpointProperties"/> instance for mocking. </returns>
        public static MachineLearningOnlineEndpointProperties MachineLearningOnlineEndpointProperties(string description = null, IDictionary<string, string> properties = null, Uri scoringUri = null, Uri swaggerUri = null, MachineLearningEndpointAuthMode authMode = default, MachineLearningEndpointAuthKeys keys = null, MachineLearningEndpointProvisioningState? provisioningState = null, string compute = null, MachineLearningPublicNetworkAccessType? publicNetworkAccess = null, IDictionary<string, int> traffic = null, IDictionary<string, int> mirrorTraffic = null)
        {
            properties ??= new Dictionary<string, string>();
            traffic ??= new Dictionary<string, int>();
            mirrorTraffic ??= new Dictionary<string, int>();

            return new MachineLearningOnlineEndpointProperties(
                description,
                properties,
                scoringUri,
                swaggerUri,
                authMode,
                keys,
                serializedAdditionalRawData: null,
                provisioningState,
                compute,
                publicNetworkAccess,
                traffic,
                mirrorTraffic);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningOnlineDeploymentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties">
        /// [Required] Additional attributes of the entity.
        /// Please note <see cref="Models.MachineLearningOnlineDeploymentProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MachineLearningKubernetesOnlineDeployment"/> and <see cref="Models.MachineLearningManagedOnlineDeployment"/>.
        /// </param>
        /// <param name="kind"> Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="sku"> Sku details required for ARM contract for Autoscaling. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningOnlineDeploymentData"/> instance for mocking. </returns>
        public static MachineLearningOnlineDeploymentData MachineLearningOnlineDeploymentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, MachineLearningOnlineDeploymentProperties properties = null, string kind = null, ManagedServiceIdentity identity = null, MachineLearningSku sku = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MachineLearningOnlineDeploymentData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                kind,
                identity,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningOnlineDeploymentProperties"/>. </summary>
        /// <param name="description"> Description of the endpoint deployment. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="codeConfiguration"> Code configuration for the endpoint deployment. </param>
        /// <param name="environmentId"> ARM resource ID or AssetId of the environment specification for the endpoint deployment. </param>
        /// <param name="environmentVariables"> Environment variables configuration for the deployment. </param>
        /// <param name="endpointComputeType"> [Required] The compute type of the endpoint. </param>
        /// <param name="scaleSettings">
        /// Scale settings for the deployment.
        /// If it is null or not provided,
        /// it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
        /// and to DefaultScaleSettings for ManagedOnlineDeployment.
        /// Please note <see cref="MachineLearningOnlineScaleSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningDefaultScaleSettings"/> and <see cref="MachineLearningTargetUtilizationScaleSettings"/>.
        /// </param>
        /// <param name="requestSettings"> Request settings for the deployment. </param>
        /// <param name="modelMountPath"> The path to mount the model in custom container. </param>
        /// <param name="appInsightsEnabled"> If true, enables Application Insights logging. </param>
        /// <param name="livenessProbe"> Liveness probe monitors the health of the container regularly. </param>
        /// <param name="readinessProbe"> Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe. </param>
        /// <param name="provisioningState"> Provisioning state for the endpoint deployment. </param>
        /// <param name="instanceType"> Compute instance type. </param>
        /// <param name="model"> The URI path to the model. </param>
        /// <param name="egressPublicNetworkAccess"> If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled. </param>
        /// <param name="dataCollector"> The mdc configuration, we disable mdc when it's null. </param>
        /// <returns> A new <see cref="Models.MachineLearningOnlineDeploymentProperties"/> instance for mocking. </returns>
        public static MachineLearningOnlineDeploymentProperties MachineLearningOnlineDeploymentProperties(string description = null, IDictionary<string, string> properties = null, MachineLearningCodeConfiguration codeConfiguration = null, string environmentId = null, IDictionary<string, string> environmentVariables = null, string endpointComputeType = null, MachineLearningOnlineScaleSettings scaleSettings = null, MachineLearningOnlineRequestSettings requestSettings = null, string modelMountPath = null, bool? appInsightsEnabled = null, MachineLearningProbeSettings livenessProbe = null, MachineLearningProbeSettings readinessProbe = null, MachineLearningDeploymentProvisioningState? provisioningState = null, string instanceType = null, string model = null, MachineLearningEgressPublicNetworkAccessType? egressPublicNetworkAccess = null, DataCollector dataCollector = null)
        {
            properties ??= new Dictionary<string, string>();
            environmentVariables ??= new Dictionary<string, string>();

            return new MachineLearningOnlineDeploymentProperties(
                description,
                properties,
                codeConfiguration,
                environmentId,
                environmentVariables,
                serializedAdditionalRawData: null,
                endpointComputeType == null ? default : new MachineLearningEndpointComputeType(endpointComputeType),
                scaleSettings,
                requestSettings,
                modelMountPath,
                appInsightsEnabled,
                livenessProbe,
                readinessProbe,
                provisioningState,
                instanceType,
                model,
                egressPublicNetworkAccess,
                dataCollector);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDeploymentLogs"/>. </summary>
        /// <param name="content"> The retrieved online deployment logs. </param>
        /// <returns> A new <see cref="Models.MachineLearningDeploymentLogs"/> instance for mocking. </returns>
        public static MachineLearningDeploymentLogs MachineLearningDeploymentLogs(string content = null)
        {
            return new MachineLearningDeploymentLogs(content, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningSkuDetail"/>. </summary>
        /// <param name="resourceType"> The resource type name. </param>
        /// <param name="sku"> Gets or sets the Sku. </param>
        /// <param name="capacity"> Gets or sets the Sku Capacity. </param>
        /// <returns> A new <see cref="Models.MachineLearningSkuDetail"/> instance for mocking. </returns>
        public static MachineLearningSkuDetail MachineLearningSkuDetail(string resourceType = null, MachineLearningSkuSetting sku = null, MachineLearningSkuCapacity capacity = null)
        {
            return new MachineLearningSkuDetail(resourceType, sku, capacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningSkuSetting"/>. </summary>
        /// <param name="name"> [Required] The name of the SKU. Ex - P3. It is typically a letter+number code. </param>
        /// <param name="tier"> This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. </param>
        /// <returns> A new <see cref="Models.MachineLearningSkuSetting"/> instance for mocking. </returns>
        public static MachineLearningSkuSetting MachineLearningSkuSetting(string name = null, MachineLearningSkuTier? tier = null)
        {
            return new MachineLearningSkuSetting(name, tier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningSkuCapacity"/>. </summary>
        /// <param name="minimum"> Gets or sets the minimum. </param>
        /// <param name="maximum"> Gets or sets the maximum. </param>
        /// <param name="default"> Gets or sets the default capacity. </param>
        /// <param name="scaleType"> Gets or sets the type of the scale. </param>
        /// <returns> A new <see cref="Models.MachineLearningSkuCapacity"/> instance for mocking. </returns>
        public static MachineLearningSkuCapacity MachineLearningSkuCapacity(int? minimum = null, int? maximum = null, int? @default = null, MachineLearningSkuScaleType? scaleType = null)
        {
            return new MachineLearningSkuCapacity(minimum, maximum, @default, scaleType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningEndpointKeyRegenerateContent"/>. </summary>
        /// <param name="keyType"> [Required] Specification for which type of key to generate. Primary or Secondary. </param>
        /// <param name="keyValue"> The value the key is set to. </param>
        /// <returns> A new <see cref="Models.MachineLearningEndpointKeyRegenerateContent"/> instance for mocking. </returns>
        public static MachineLearningEndpointKeyRegenerateContent MachineLearningEndpointKeyRegenerateContent(MachineLearningKeyType keyType = default, string keyValue = null)
        {
            return new MachineLearningEndpointKeyRegenerateContent(keyType, keyValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningEndpointAuthToken"/>. </summary>
        /// <param name="accessToken"> Access token for endpoint authentication. </param>
        /// <param name="tokenType"> Access token type. </param>
        /// <param name="expireOn"> Access token expiry time (UTC). </param>
        /// <param name="refreshOn"> Refresh access token after time (UTC). </param>
        /// <returns> A new <see cref="Models.MachineLearningEndpointAuthToken"/> instance for mocking. </returns>
        public static MachineLearningEndpointAuthToken MachineLearningEndpointAuthToken(string accessToken = null, string tokenType = null, DateTimeOffset? expireOn = null, DateTimeOffset? refreshOn = null)
        {
            return new MachineLearningEndpointAuthToken(accessToken, tokenType, expireOn, refreshOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningScheduleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningScheduleData"/> instance for mocking. </returns>
        public static MachineLearningScheduleData MachineLearningScheduleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MachineLearningScheduleProperties properties = null)
        {
            return new MachineLearningScheduleData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningScheduleProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="displayName"> Display name of schedule. </param>
        /// <param name="isEnabled"> Is the schedule enabled?. </param>
        /// <param name="trigger">
        /// [Required] Specifies the trigger details
        /// Please note <see cref="MachineLearningTriggerBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="CronTrigger"/> and <see cref="MachineLearningRecurrenceTrigger"/>.
        /// </param>
        /// <param name="action">
        /// [Required] Specifies the action of the schedule
        /// Please note <see cref="MachineLearningScheduleAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningJobScheduleAction"/>, <see cref="CreateMonitorAction"/> and <see cref="MachineLearningEndpointScheduleAction"/>.
        /// </param>
        /// <param name="provisioningState"> Provisioning state for the schedule. </param>
        /// <returns> A new <see cref="Models.MachineLearningScheduleProperties"/> instance for mocking. </returns>
        public static MachineLearningScheduleProperties MachineLearningScheduleProperties(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, string displayName = null, bool? isEnabled = null, MachineLearningTriggerBase trigger = null, MachineLearningScheduleAction action = null, MachineLearningScheduleProvisioningStatus? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningScheduleProperties(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                displayName,
                isEnabled,
                trigger,
                action,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningServerlessEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> [Required] Additional attributes of the entity. </param>
        /// <param name="kind"> Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="sku"> Sku details required for ARM contract for Autoscaling. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningServerlessEndpointData"/> instance for mocking. </returns>
        public static MachineLearningServerlessEndpointData MachineLearningServerlessEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ServerlessEndpointProperties properties = null, string kind = null, ManagedServiceIdentity identity = null, MachineLearningSku sku = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MachineLearningServerlessEndpointData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                kind,
                identity,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerlessEndpointProperties"/>. </summary>
        /// <param name="modelId"> The model settings (model id) for the model being serviced on the ServerlessEndpoint. </param>
        /// <param name="authMode"> [Required] Specifies the authentication mode for the Serverless endpoint. </param>
        /// <param name="inferenceEndpoint"> The inference uri to target when making requests against the serverless endpoint. </param>
        /// <param name="provisioningState"> Provisioning state for the endpoint. </param>
        /// <param name="endpointState"> The current state of the ServerlessEndpoint. </param>
        /// <param name="marketplaceSubscriptionId"> The MarketplaceSubscription Azure ID associated to this ServerlessEndpoint. </param>
        /// <param name="contentSafetyStatus"> Specifies the content safety options. If omitted, the default content safety settings will be configured. </param>
        /// <returns> A new <see cref="Models.ServerlessEndpointProperties"/> instance for mocking. </returns>
        public static ServerlessEndpointProperties ServerlessEndpointProperties(string modelId = null, ServerlessInferenceEndpointAuthMode authMode = default, ServerlessInferenceEndpoint inferenceEndpoint = null, MachineLearningEndpointProvisioningState? provisioningState = null, ServerlessEndpointState? endpointState = null, string marketplaceSubscriptionId = null, ContentSafetyStatus? contentSafetyStatus = null)
        {
            return new ServerlessEndpointProperties(
                modelId != null ? new ModelSettings(modelId, serializedAdditionalRawData: null) : null,
                authMode,
                inferenceEndpoint,
                provisioningState,
                endpointState,
                marketplaceSubscriptionId,
                contentSafetyStatus.HasValue ? new ContentSafety(contentSafetyStatus.Value, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerlessInferenceEndpoint"/>. </summary>
        /// <param name="uri"> [Required] The inference uri to target when making requests against the Serverless Endpoint. </param>
        /// <param name="headers"> Specifies any required headers to target this serverless endpoint. </param>
        /// <returns> A new <see cref="Models.ServerlessInferenceEndpoint"/> instance for mocking. </returns>
        public static ServerlessInferenceEndpoint ServerlessInferenceEndpoint(Uri uri = null, IReadOnlyDictionary<string, string> headers = null)
        {
            headers ??= new Dictionary<string, string>();

            return new ServerlessInferenceEndpoint(uri, headers, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearning.MachineLearningRegistryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="kind"> Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type. </param>
        /// <param name="sku"> Sku details required for ARM contract for Autoscaling. </param>
        /// <param name="discoveryUri"> Discovery URL for the Registry. </param>
        /// <param name="intellectualPropertyPublisher"> IntellectualPropertyPublisher for the registry. </param>
        /// <param name="managedResourceId"> ResourceId of the managed RG if the registry has system created resources. </param>
        /// <param name="mlFlowRegistryUri"> MLFlow Registry URI for the Registry. </param>
        /// <param name="registryPrivateEndpointConnections"> Private endpoint connections info used for pending connections in private link portal. </param>
        /// <param name="publicNetworkAccess">
        /// Is the Registry accessible from the internet?
        /// Possible values: "Enabled" or "Disabled"
        /// </param>
        /// <param name="regionDetails"> Details of each region the registry is in. </param>
        /// <returns> A new <see cref="MachineLearning.MachineLearningRegistryData"/> instance for mocking. </returns>
        public static MachineLearningRegistryData MachineLearningRegistryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, string kind = null, MachineLearningSku sku = null, Uri discoveryUri = null, string intellectualPropertyPublisher = null, ResourceIdentifier managedResourceId = null, Uri mlFlowRegistryUri = null, IEnumerable<RegistryPrivateEndpointConnection> registryPrivateEndpointConnections = null, string publicNetworkAccess = null, IEnumerable<RegistryRegionArmDetails> regionDetails = null)
        {
            tags ??= new Dictionary<string, string>();
            registryPrivateEndpointConnections ??= new List<RegistryPrivateEndpointConnection>();
            regionDetails ??= new List<RegistryRegionArmDetails>();

            return new MachineLearningRegistryData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                kind,
                sku,
                discoveryUri,
                intellectualPropertyPublisher,
                managedResourceId != null ? new ArmResourceId(managedResourceId, serializedAdditionalRawData: null) : null,
                mlFlowRegistryUri,
                registryPrivateEndpointConnections?.ToList(),
                publicNetworkAccess,
                regionDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RegistryPrivateEndpoint"/>. </summary>
        /// <param name="id"> The ARM identifier for Private Endpoint. </param>
        /// <param name="subnetArmId"> The subnetId that the private endpoint is connected to. </param>
        /// <returns> A new <see cref="Models.RegistryPrivateEndpoint"/> instance for mocking. </returns>
        public static RegistryPrivateEndpoint RegistryPrivateEndpoint(ResourceIdentifier id = null, ResourceIdentifier subnetArmId = null)
        {
            return new RegistryPrivateEndpoint(id, serializedAdditionalRawData: null, subnetArmId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningUserFeature"/>. </summary>
        /// <param name="id"> Specifies the feature ID. </param>
        /// <param name="displayName"> Specifies the feature name. </param>
        /// <param name="description"> Describes the feature for user experience. </param>
        /// <returns> A new <see cref="Models.MachineLearningUserFeature"/> instance for mocking. </returns>
        public static MachineLearningUserFeature MachineLearningUserFeature(string id = null, string displayName = null, string description = null)
        {
            return new MachineLearningUserFeature(id, displayName, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningAksCompute"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="properties"> AKS properties. </param>
        /// <returns> A new <see cref="Models.MachineLearningAksCompute"/> instance for mocking. </returns>
        public static MachineLearningAksCompute MachineLearningAksCompute(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, MachineLearningAksComputeProperties properties = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningAksCompute(
                ComputeType.Aks,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningAksComputeProperties"/>. </summary>
        /// <param name="clusterFqdn"> Cluster full qualified domain name. </param>
        /// <param name="systemServices"> System services. </param>
        /// <param name="agentCount"> Number of agents. </param>
        /// <param name="agentVmSize"> Agent virtual machine size. </param>
        /// <param name="clusterPurpose"> Intended usage of the cluster. </param>
        /// <param name="sslConfiguration"> SSL configuration. </param>
        /// <param name="aksNetworkingConfiguration"> AKS networking configuration for vnet. </param>
        /// <param name="loadBalancerType"> Load Balancer Type. </param>
        /// <param name="loadBalancerSubnet"> Load Balancer Subnet. </param>
        /// <returns> A new <see cref="Models.MachineLearningAksComputeProperties"/> instance for mocking. </returns>
        public static MachineLearningAksComputeProperties MachineLearningAksComputeProperties(string clusterFqdn = null, IEnumerable<MachineLearningComputeSystemService> systemServices = null, int? agentCount = null, string agentVmSize = null, MachineLearningClusterPurpose? clusterPurpose = null, MachineLearningSslConfiguration sslConfiguration = null, MachineLearningAksNetworkingConfiguration aksNetworkingConfiguration = null, MachineLearningLoadBalancerType? loadBalancerType = null, string loadBalancerSubnet = null)
        {
            systemServices ??= new List<MachineLearningComputeSystemService>();

            return new MachineLearningAksComputeProperties(
                clusterFqdn,
                systemServices?.ToList(),
                agentCount,
                agentVmSize,
                clusterPurpose,
                sslConfiguration,
                aksNetworkingConfiguration,
                loadBalancerType,
                loadBalancerSubnet,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeSystemService"/>. </summary>
        /// <param name="systemServiceType"> The type of this system service. </param>
        /// <param name="publicIPAddress"> Public IP address. </param>
        /// <param name="version"> The version for this type. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeSystemService"/> instance for mocking. </returns>
        public static MachineLearningComputeSystemService MachineLearningComputeSystemService(string systemServiceType = null, string publicIPAddress = null, string version = null)
        {
            return new MachineLearningComputeSystemService(systemServiceType, publicIPAddress, version, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningKubernetesCompute"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="properties"> Properties of Kubernetes. </param>
        /// <returns> A new <see cref="Models.MachineLearningKubernetesCompute"/> instance for mocking. </returns>
        public static MachineLearningKubernetesCompute MachineLearningKubernetesCompute(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, MachineLearningKubernetesProperties properties = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningKubernetesCompute(
                ComputeType.Kubernetes,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlComputeProperties"/>. </summary>
        /// <param name="osType"> Compute OS Type. </param>
        /// <param name="vmSize"> Virtual Machine Size. </param>
        /// <param name="vmPriority"> Virtual Machine priority. </param>
        /// <param name="virtualMachineImageId"> Virtual Machine image for AML Compute - windows only. </param>
        /// <param name="isolatedNetwork"> Network is isolated or not. </param>
        /// <param name="scaleSettings"> Scale settings for AML Compute. </param>
        /// <param name="userAccountCredentials"> Credentials for an administrator user account that will be created on each compute node. </param>
        /// <param name="subnetId"> Virtual network subnet resource ID the compute nodes belong to. </param>
        /// <param name="remoteLoginPortPublicAccess"> State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled. </param>
        /// <param name="allocationState"> Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute. </param>
        /// <param name="allocationStateTransitionOn"> The time at which the compute entered its current allocation state. </param>
        /// <param name="errors"> Collection of errors encountered by various compute nodes during node setup. </param>
        /// <param name="currentNodeCount"> The number of compute nodes currently assigned to the compute. </param>
        /// <param name="targetNodeCount"> The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation. </param>
        /// <param name="nodeStateCounts"> Counts of various node states on the compute. </param>
        /// <param name="enableNodePublicIP"> Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs. </param>
        /// <param name="propertyBag"> A property bag containing additional properties. </param>
        /// <returns> A new <see cref="Models.AmlComputeProperties"/> instance for mocking. </returns>
        public static AmlComputeProperties AmlComputeProperties(MachineLearningOSType? osType = null, string vmSize = null, MachineLearningVmPriority? vmPriority = null, string virtualMachineImageId = null, bool? isolatedNetwork = null, AmlComputeScaleSettings scaleSettings = null, MachineLearningUserAccountCredentials userAccountCredentials = null, ResourceIdentifier subnetId = null, MachineLearningRemoteLoginPortPublicAccess? remoteLoginPortPublicAccess = null, MachineLearningAllocationState? allocationState = null, DateTimeOffset? allocationStateTransitionOn = null, IEnumerable<MachineLearningError> errors = null, int? currentNodeCount = null, int? targetNodeCount = null, MachineLearningNodeStateCounts nodeStateCounts = null, bool? enableNodePublicIP = null, BinaryData propertyBag = null)
        {
            errors ??= new List<MachineLearningError>();

            return new AmlComputeProperties(
                osType,
                vmSize,
                vmPriority,
                virtualMachineImageId != null ? new VirtualMachineImage(virtualMachineImageId, serializedAdditionalRawData: null) : null,
                isolatedNetwork,
                scaleSettings,
                userAccountCredentials,
                subnetId != null ? new ResourceId(subnetId, serializedAdditionalRawData: null) : null,
                remoteLoginPortPublicAccess,
                allocationState,
                allocationStateTransitionOn,
                errors?.ToList(),
                currentNodeCount,
                targetNodeCount,
                nodeStateCounts,
                enableNodePublicIP,
                propertyBag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningNodeStateCounts"/>. </summary>
        /// <param name="idleNodeCount"> Number of compute nodes in idle state. </param>
        /// <param name="runningNodeCount"> Number of compute nodes which are running jobs. </param>
        /// <param name="preparingNodeCount"> Number of compute nodes which are being prepared. </param>
        /// <param name="unusableNodeCount"> Number of compute nodes which are in unusable state. </param>
        /// <param name="leavingNodeCount"> Number of compute nodes which are leaving the amlCompute. </param>
        /// <param name="preemptedNodeCount"> Number of compute nodes which are in preempted state. </param>
        /// <returns> A new <see cref="Models.MachineLearningNodeStateCounts"/> instance for mocking. </returns>
        public static MachineLearningNodeStateCounts MachineLearningNodeStateCounts(int? idleNodeCount = null, int? runningNodeCount = null, int? preparingNodeCount = null, int? unusableNodeCount = null, int? leavingNodeCount = null, int? preemptedNodeCount = null)
        {
            return new MachineLearningNodeStateCounts(
                idleNodeCount,
                runningNodeCount,
                preparingNodeCount,
                unusableNodeCount,
                leavingNodeCount,
                preemptedNodeCount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlCompute"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="properties"> Properties of AmlCompute. </param>
        /// <returns> A new <see cref="Models.AmlCompute"/> instance for mocking. </returns>
        public static AmlCompute AmlCompute(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, AmlComputeProperties properties = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new AmlCompute(
                ComputeType.AmlCompute,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceSshSettings"/>. </summary>
        /// <param name="sshPublicAccess"> State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable. </param>
        /// <param name="adminUserName"> Describes the admin user name. </param>
        /// <param name="sshPort"> Describes the port for connecting through SSH. </param>
        /// <param name="adminPublicKey"> Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceSshSettings"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceSshSettings MachineLearningComputeInstanceSshSettings(MachineLearningSshPublicAccess? sshPublicAccess = null, string adminUserName = null, int? sshPort = null, string adminPublicKey = null)
        {
            return new MachineLearningComputeInstanceSshSettings(sshPublicAccess, adminUserName, sshPort, adminPublicKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ImageMetadata"/>. </summary>
        /// <param name="currentImageVersion"> Specifies the current operating system image version this compute instance is running on. </param>
        /// <param name="latestImageVersion"> Specifies the latest available operating system image version. </param>
        /// <param name="isLatestOSImageVersion"> Specifies whether this compute instance is running on the latest operating system image. </param>
        /// <returns> A new <see cref="Models.ImageMetadata"/> instance for mocking. </returns>
        public static ImageMetadata ImageMetadata(string currentImageVersion = null, string latestImageVersion = null, bool? isLatestOSImageVersion = null)
        {
            return new ImageMetadata(currentImageVersion, latestImageVersion, isLatestOSImageVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceConnectivityEndpoints"/>. </summary>
        /// <param name="publicIPAddress"> Public IP Address of this ComputeInstance. </param>
        /// <param name="privateIPAddress"> Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed). </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceConnectivityEndpoints"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceConnectivityEndpoints MachineLearningComputeInstanceConnectivityEndpoints(string publicIPAddress = null, string privateIPAddress = null)
        {
            return new MachineLearningComputeInstanceConnectivityEndpoints(publicIPAddress, privateIPAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceApplication"/>. </summary>
        /// <param name="displayName"> Name of the ComputeInstance application. </param>
        /// <param name="endpointUri"> Application' endpoint URI. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceApplication"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceApplication MachineLearningComputeInstanceApplication(string displayName = null, Uri endpointUri = null)
        {
            return new MachineLearningComputeInstanceApplication(displayName, endpointUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceCreatedBy"/>. </summary>
        /// <param name="userName"> Name of the user. </param>
        /// <param name="userOrgId"> Uniquely identifies user' Azure Active Directory organization. </param>
        /// <param name="userId"> Uniquely identifies the user within his/her organization. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceCreatedBy"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceCreatedBy MachineLearningComputeInstanceCreatedBy(string userName = null, string userOrgId = null, string userId = null)
        {
            return new MachineLearningComputeInstanceCreatedBy(userName, userOrgId, userId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceLastOperation"/>. </summary>
        /// <param name="operationName"> Name of the last operation. </param>
        /// <param name="operationOn"> Time of the last operation. </param>
        /// <param name="operationStatus"> Operation status. </param>
        /// <param name="operationTrigger"> Trigger of operation. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceLastOperation"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceLastOperation MachineLearningComputeInstanceLastOperation(MachineLearningOperationName? operationName = null, DateTimeOffset? operationOn = null, MachineLearningOperationStatus? operationStatus = null, MachineLearningOperationTrigger? operationTrigger = null)
        {
            return new MachineLearningComputeInstanceLastOperation(operationName, operationOn, operationStatus, operationTrigger, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeStartStopSchedule"/>. </summary>
        /// <param name="id"> A system assigned id for the schedule. </param>
        /// <param name="provisioningStatus"> The current deployment state of schedule. </param>
        /// <param name="status"> Is the schedule enabled or disabled?. </param>
        /// <param name="action"> [Required] The compute power action. </param>
        /// <param name="triggerType"> [Required] The schedule trigger type. </param>
        /// <param name="recurrenceSchedule"> Required if triggerType is Recurrence. </param>
        /// <param name="cronSchedule"> Required if triggerType is Cron. </param>
        /// <param name="schedule"> [Deprecated] Not used any more. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeStartStopSchedule"/> instance for mocking. </returns>
        public static MachineLearningComputeStartStopSchedule MachineLearningComputeStartStopSchedule(string id = null, MachineLearningComputeProvisioningStatus? provisioningStatus = null, MachineLearningScheduleStatus? status = null, MachineLearningComputePowerAction? action = null, MachineLearningTriggerType? triggerType = null, ComputeStartStopRecurrenceSchedule recurrenceSchedule = null, ComputeStartStopCronSchedule cronSchedule = null, MachineLearningScheduleBase schedule = null)
        {
            return new MachineLearningComputeStartStopSchedule(
                id,
                provisioningStatus,
                status,
                action,
                triggerType,
                recurrenceSchedule,
                cronSchedule,
                schedule,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceContainer"/>. </summary>
        /// <param name="name"> Name of the ComputeInstance container. </param>
        /// <param name="autosave"> Auto save settings. </param>
        /// <param name="gpu"> Information of GPU. </param>
        /// <param name="network"> network of this container. </param>
        /// <param name="environment"> Environment information of this container. </param>
        /// <param name="services"> services of this containers. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceContainer"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceContainer MachineLearningComputeInstanceContainer(string name = null, MachineLearningComputeInstanceAutosave? autosave = null, string gpu = null, MachineLearningNetwork? network = null, MachineLearningComputeInstanceEnvironmentInfo environment = null, IEnumerable<BinaryData> services = null)
        {
            services ??= new List<BinaryData>();

            return new MachineLearningComputeInstanceContainer(
                name,
                autosave,
                gpu,
                network,
                environment,
                services?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceEnvironmentInfo"/>. </summary>
        /// <param name="name"> name of environment. </param>
        /// <param name="version"> version of environment. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceEnvironmentInfo"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceEnvironmentInfo MachineLearningComputeInstanceEnvironmentInfo(string name = null, string version = null)
        {
            return new MachineLearningComputeInstanceEnvironmentInfo(name, version, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceDataDisk"/>. </summary>
        /// <param name="caching"> Caching type of Data Disk. </param>
        /// <param name="diskSizeGB"> The initial disk size in gigabytes. </param>
        /// <param name="lun"> The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. </param>
        /// <param name="storageAccountType"> type of this storage account. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceDataDisk"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceDataDisk MachineLearningComputeInstanceDataDisk(MachineLearningCachingType? caching = null, int? diskSizeGB = null, int? lun = null, MachineLearningStorageAccountType? storageAccountType = null)
        {
            return new MachineLearningComputeInstanceDataDisk(caching, diskSizeGB, lun, storageAccountType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstanceDataMount"/>. </summary>
        /// <param name="source"> Source of the ComputeInstance data mount. </param>
        /// <param name="sourceType"> Data source type. </param>
        /// <param name="mountName"> name of the ComputeInstance data mount. </param>
        /// <param name="mountAction"> Mount Action. </param>
        /// <param name="createdBy"> who this data mount created by. </param>
        /// <param name="mountPath"> Path of this data mount. </param>
        /// <param name="mountState"> Mount state. </param>
        /// <param name="mountedOn"> The time when the disk mounted. </param>
        /// <param name="error"> Error of this data mount. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstanceDataMount"/> instance for mocking. </returns>
        public static MachineLearningComputeInstanceDataMount MachineLearningComputeInstanceDataMount(string source = null, MachineLearningSourceType? sourceType = null, string mountName = null, MachineLearningMountAction? mountAction = null, string createdBy = null, string mountPath = null, MachineLearningMountState? mountState = null, DateTimeOffset? mountedOn = null, string error = null)
        {
            return new MachineLearningComputeInstanceDataMount(
                source,
                sourceType,
                mountName,
                mountAction,
                createdBy,
                mountPath,
                mountState,
                mountedOn,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningComputeInstance"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="properties"> Properties of ComputeInstance. </param>
        /// <returns> A new <see cref="Models.MachineLearningComputeInstance"/> instance for mocking. </returns>
        public static MachineLearningComputeInstance MachineLearningComputeInstance(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, MachineLearningComputeInstanceProperties properties = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningComputeInstance(
                ComputeType.ComputeInstance,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningVirtualMachineCompute"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="Models.MachineLearningVirtualMachineCompute"/> instance for mocking. </returns>
        public static MachineLearningVirtualMachineCompute MachineLearningVirtualMachineCompute(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, MachineLearningVirtualMachineProperties properties = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningVirtualMachineCompute(
                ComputeType.VirtualMachine,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningHDInsightCompute"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="properties"> HDInsight compute properties. </param>
        /// <returns> A new <see cref="Models.MachineLearningHDInsightCompute"/> instance for mocking. </returns>
        public static MachineLearningHDInsightCompute MachineLearningHDInsightCompute(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, MachineLearningHDInsightProperties properties = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningHDInsightCompute(
                ComputeType.HDInsight,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDataFactoryCompute"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <returns> A new <see cref="Models.MachineLearningDataFactoryCompute"/> instance for mocking. </returns>
        public static MachineLearningDataFactoryCompute MachineLearningDataFactoryCompute(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningDataFactoryCompute(
                ComputeType.DataFactory,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDatabricksCompute"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="properties"> Properties of Databricks. </param>
        /// <returns> A new <see cref="Models.MachineLearningDatabricksCompute"/> instance for mocking. </returns>
        public static MachineLearningDatabricksCompute MachineLearningDatabricksCompute(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, MachineLearningDatabricksProperties properties = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningDatabricksCompute(
                ComputeType.Databricks,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDataLakeAnalytics"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="dataLakeStoreAccountName"></param>
        /// <returns> A new <see cref="Models.MachineLearningDataLakeAnalytics"/> instance for mocking. </returns>
        public static MachineLearningDataLakeAnalytics MachineLearningDataLakeAnalytics(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, string dataLakeStoreAccountName = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningDataLakeAnalytics(
                ComputeType.DataLakeAnalytics,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                dataLakeStoreAccountName != null ? new MachineLearningDataLakeAnalyticsProperties(dataLakeStoreAccountName, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningSynapseSpark"/>. </summary>
        /// <param name="computeLocation"> Location for the underlying compute. </param>
        /// <param name="provisioningState"> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </param>
        /// <param name="description"> The description of the Machine Learning compute. </param>
        /// <param name="createdOn"> The time at which the compute was created. </param>
        /// <param name="modifiedOn"> The time at which the compute was last modified. </param>
        /// <param name="resourceId"> ARM resource id of the underlying compute. </param>
        /// <param name="provisioningErrors"> Errors during provisioning. </param>
        /// <param name="isAttachedCompute"> Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="Models.MachineLearningSynapseSpark"/> instance for mocking. </returns>
        public static MachineLearningSynapseSpark MachineLearningSynapseSpark(string computeLocation = null, MachineLearningProvisioningState? provisioningState = null, string description = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, ResourceIdentifier resourceId = null, IEnumerable<MachineLearningError> provisioningErrors = null, bool? isAttachedCompute = null, bool? disableLocalAuth = null, MachineLearningSynapseSparkProperties properties = null)
        {
            provisioningErrors ??= new List<MachineLearningError>();

            return new MachineLearningSynapseSpark(
                ComputeType.SynapseSpark,
                computeLocation,
                provisioningState,
                description,
                createdOn,
                modifiedOn,
                resourceId,
                provisioningErrors?.ToList(),
                isAttachedCompute,
                disableLocalAuth,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningAksComputeSecrets"/>. </summary>
        /// <param name="userKubeConfig"> Content of kubeconfig file that can be used to connect to the Kubernetes cluster. </param>
        /// <param name="adminKubeConfig"> Content of kubeconfig file that can be used to connect to the Kubernetes cluster. </param>
        /// <param name="imagePullSecretName"> Image registry pull secret. </param>
        /// <returns> A new <see cref="Models.MachineLearningAksComputeSecrets"/> instance for mocking. </returns>
        public static MachineLearningAksComputeSecrets MachineLearningAksComputeSecrets(string userKubeConfig = null, string adminKubeConfig = null, string imagePullSecretName = null)
        {
            return new MachineLearningAksComputeSecrets(ComputeType.Aks, serializedAdditionalRawData: null, userKubeConfig, adminKubeConfig, imagePullSecretName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningVirtualMachineSecrets"/>. </summary>
        /// <param name="administratorAccount"> Admin credentials for virtual machine. </param>
        /// <returns> A new <see cref="Models.MachineLearningVirtualMachineSecrets"/> instance for mocking. </returns>
        public static MachineLearningVirtualMachineSecrets MachineLearningVirtualMachineSecrets(MachineLearningVmSshCredentials administratorAccount = null)
        {
            return new MachineLearningVirtualMachineSecrets(ComputeType.VirtualMachine, serializedAdditionalRawData: null, administratorAccount);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningDatabricksComputeSecrets"/>. </summary>
        /// <param name="databricksAccessToken"> access token for databricks account. </param>
        /// <returns> A new <see cref="Models.MachineLearningDatabricksComputeSecrets"/> instance for mocking. </returns>
        public static MachineLearningDatabricksComputeSecrets MachineLearningDatabricksComputeSecrets(string databricksAccessToken = null)
        {
            return new MachineLearningDatabricksComputeSecrets(ComputeType.Databricks, serializedAdditionalRawData: null, databricksAccessToken);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceTagDestination"/>. </summary>
        /// <param name="action"> The action enum for networking rule. </param>
        /// <param name="addressPrefixes"> Optional, if provided, the ServiceTag property will be ignored. </param>
        /// <param name="portRanges"></param>
        /// <param name="protocol"></param>
        /// <param name="serviceTag"></param>
        /// <returns> A new <see cref="Models.ServiceTagDestination"/> instance for mocking. </returns>
        public static ServiceTagDestination ServiceTagDestination(NetworkingRuleAction? action = null, IEnumerable<string> addressPrefixes = null, string portRanges = null, string protocol = null, string serviceTag = null)
        {
            addressPrefixes ??= new List<string>();

            return new ServiceTagDestination(
                action,
                addressPrefixes?.ToList(),
                portRanges,
                protocol,
                serviceTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningPatAuthTypeWorkspaceConnection"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentialsPat"></param>
        /// <returns> A new <see cref="Models.MachineLearningPatAuthTypeWorkspaceConnection"/> instance for mocking. </returns>
        public static MachineLearningPatAuthTypeWorkspaceConnection MachineLearningPatAuthTypeWorkspaceConnection(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, string credentialsPat = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new MachineLearningPatAuthTypeWorkspaceConnection(
                MachineLearningConnectionAuthType.Pat,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentialsPat != null ? new WorkspaceConnectionPersonalAccessToken(credentialsPat, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningSasAuthTypeWorkspaceConnection"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentialsSas"></param>
        /// <returns> A new <see cref="Models.MachineLearningSasAuthTypeWorkspaceConnection"/> instance for mocking. </returns>
        public static MachineLearningSasAuthTypeWorkspaceConnection MachineLearningSasAuthTypeWorkspaceConnection(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, string credentialsSas = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new MachineLearningSasAuthTypeWorkspaceConnection(
                MachineLearningConnectionAuthType.Sas,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentialsSas != null ? new WorkspaceConnectionSharedAccessSignature(credentialsSas, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningUsernamePasswordAuthTypeWorkspaceConnection"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentials"></param>
        /// <returns> A new <see cref="Models.MachineLearningUsernamePasswordAuthTypeWorkspaceConnection"/> instance for mocking. </returns>
        public static MachineLearningUsernamePasswordAuthTypeWorkspaceConnection MachineLearningUsernamePasswordAuthTypeWorkspaceConnection(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, MachineLearningWorkspaceConnectionUsernamePassword credentials = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new MachineLearningUsernamePasswordAuthTypeWorkspaceConnection(
                MachineLearningConnectionAuthType.UsernamePassword,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentials);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningNoneAuthTypeWorkspaceConnection"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <returns> A new <see cref="Models.MachineLearningNoneAuthTypeWorkspaceConnection"/> instance for mocking. </returns>
        public static MachineLearningNoneAuthTypeWorkspaceConnection MachineLearningNoneAuthTypeWorkspaceConnection(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new MachineLearningNoneAuthTypeWorkspaceConnection(
                MachineLearningConnectionAuthType.None,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningManagedIdentityAuthTypeWorkspaceConnection"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentials"></param>
        /// <returns> A new <see cref="Models.MachineLearningManagedIdentityAuthTypeWorkspaceConnection"/> instance for mocking. </returns>
        public static MachineLearningManagedIdentityAuthTypeWorkspaceConnection MachineLearningManagedIdentityAuthTypeWorkspaceConnection(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, MachineLearningWorkspaceConnectionManagedIdentity credentials = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new MachineLearningManagedIdentityAuthTypeWorkspaceConnection(
                MachineLearningConnectionAuthType.ManagedIdentity,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentials);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AadAuthTypeWorkspaceConnectionProperties"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <returns> A new <see cref="Models.AadAuthTypeWorkspaceConnectionProperties"/> instance for mocking. </returns>
        public static AadAuthTypeWorkspaceConnectionProperties AadAuthTypeWorkspaceConnectionProperties(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new AadAuthTypeWorkspaceConnectionProperties(
                MachineLearningConnectionAuthType.Aad,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessKeyAuthTypeWorkspaceConnectionProperties"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentials"></param>
        /// <returns> A new <see cref="Models.AccessKeyAuthTypeWorkspaceConnectionProperties"/> instance for mocking. </returns>
        public static AccessKeyAuthTypeWorkspaceConnectionProperties AccessKeyAuthTypeWorkspaceConnectionProperties(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, WorkspaceConnectionAccessKey credentials = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new AccessKeyAuthTypeWorkspaceConnectionProperties(
                MachineLearningConnectionAuthType.AccessKey,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentials);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccountKeyAuthTypeWorkspaceConnectionProperties"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentialsKey"></param>
        /// <returns> A new <see cref="Models.AccountKeyAuthTypeWorkspaceConnectionProperties"/> instance for mocking. </returns>
        public static AccountKeyAuthTypeWorkspaceConnectionProperties AccountKeyAuthTypeWorkspaceConnectionProperties(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, string credentialsKey = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new AccountKeyAuthTypeWorkspaceConnectionProperties(
                MachineLearningConnectionAuthType.AccountKey,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentialsKey != null ? new WorkspaceConnectionAccountKey(credentialsKey, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApiKeyAuthWorkspaceConnectionProperties"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentialsKey"> Api key object for workspace connection credential. </param>
        /// <returns> A new <see cref="Models.ApiKeyAuthWorkspaceConnectionProperties"/> instance for mocking. </returns>
        public static ApiKeyAuthWorkspaceConnectionProperties ApiKeyAuthWorkspaceConnectionProperties(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, string credentialsKey = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new ApiKeyAuthWorkspaceConnectionProperties(
                MachineLearningConnectionAuthType.ApiKey,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentialsKey != null ? new WorkspaceConnectionApiKey(credentialsKey, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomKeysWorkspaceConnectionProperties"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentialsKeys"> Custom Keys credential object. </param>
        /// <returns> A new <see cref="Models.CustomKeysWorkspaceConnectionProperties"/> instance for mocking. </returns>
        public static CustomKeysWorkspaceConnectionProperties CustomKeysWorkspaceConnectionProperties(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, IDictionary<string, string> credentialsKeys = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();
            credentialsKeys ??= new Dictionary<string, string>();

            return new CustomKeysWorkspaceConnectionProperties(
                MachineLearningConnectionAuthType.CustomKeys,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentialsKeys != null ? new CustomKeys(credentialsKeys, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OAuth2AuthTypeWorkspaceConnectionProperties"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentials">
        /// ClientId and ClientSecret are required. Other properties are optional
        /// depending on each OAuth2 provider's implementation.
        /// </param>
        /// <returns> A new <see cref="Models.OAuth2AuthTypeWorkspaceConnectionProperties"/> instance for mocking. </returns>
        public static OAuth2AuthTypeWorkspaceConnectionProperties OAuth2AuthTypeWorkspaceConnectionProperties(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, WorkspaceConnectionOAuth2 credentials = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new OAuth2AuthTypeWorkspaceConnectionProperties(
                MachineLearningConnectionAuthType.OAuth2,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentials);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServicePrincipalAuthTypeWorkspaceConnectionProperties"/>. </summary>
        /// <param name="category"> Category of the connection. </param>
        /// <param name="createdByWorkspaceArmId"></param>
        /// <param name="expiryOn"></param>
        /// <param name="group"> Group based on connection category. </param>
        /// <param name="isSharedToAll"></param>
        /// <param name="target"></param>
        /// <param name="metadata"> Store user metadata for this connection. </param>
        /// <param name="sharedUserList"></param>
        /// <param name="value"> Value details of the workspace connection. </param>
        /// <param name="valueFormat"> format for the workspace connection value. </param>
        /// <param name="credentials"></param>
        /// <returns> A new <see cref="Models.ServicePrincipalAuthTypeWorkspaceConnectionProperties"/> instance for mocking. </returns>
        public static ServicePrincipalAuthTypeWorkspaceConnectionProperties ServicePrincipalAuthTypeWorkspaceConnectionProperties(MachineLearningConnectionCategory? category = null, ResourceIdentifier createdByWorkspaceArmId = null, DateTimeOffset? expiryOn = null, WorkspaceConnectionGroup? group = null, bool? isSharedToAll = null, string target = null, IDictionary<string, string> metadata = null, IEnumerable<string> sharedUserList = null, string value = null, MachineLearningValueFormat? valueFormat = null, WorkspaceConnectionServicePrincipal credentials = null)
        {
            metadata ??= new Dictionary<string, string>();
            sharedUserList ??= new List<string>();

            return new ServicePrincipalAuthTypeWorkspaceConnectionProperties(
                MachineLearningConnectionAuthType.ServicePrincipal,
                category,
                createdByWorkspaceArmId,
                expiryOn,
                group,
                isSharedToAll,
                target,
                metadata,
                sharedUserList?.ToList(),
                value,
                valueFormat,
                serializedAdditionalRawData: null,
                credentials);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutoMLJob"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="displayName"> Display name of job. </param>
        /// <param name="status"> Status of the job. </param>
        /// <param name="experimentName"> The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment. </param>
        /// <param name="services">
        /// List of JobEndpoints.
        /// For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        /// </param>
        /// <param name="computeId"> ARM resource ID of the compute resource. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="identity">
        /// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        /// Defaults to AmlToken if null.
        /// Please note <see cref="MachineLearningIdentityConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmlToken"/>, <see cref="MachineLearningManagedIdentity"/> and <see cref="MachineLearningUserIdentity"/>.
        /// </param>
        /// <param name="componentId"> ARM resource ID of the component resource. </param>
        /// <param name="notificationSetting"> Notification setting for the job. </param>
        /// <param name="resources"> Compute Resource configuration for the job. </param>
        /// <param name="environmentId">
        /// The ARM resource ID of the Environment specification for the job.
        /// This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
        /// </param>
        /// <param name="environmentVariables"> Environment variables included in the job. </param>
        /// <param name="taskDetails">
        /// [Required] This represents scenario which can be one of Tables/NLP/Image
        /// Please note <see cref="AutoMLVertical"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ClassificationTask"/>, <see cref="MachineLearningForecasting"/>, <see cref="ImageClassification"/>, <see cref="ImageClassificationMultilabel"/>, <see cref="ImageInstanceSegmentation"/>, <see cref="ImageObjectDetection"/>, <see cref="AutoMLVerticalRegression"/>, <see cref="TextClassification"/>, <see cref="Models.TextClassificationMultilabel"/> and <see cref="Models.TextNer"/>.
        /// </param>
        /// <param name="outputs">
        /// Mapping of output data bindings used in the job.
        /// Please note <see cref="MachineLearningJobOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobOutput"/>, <see cref="MachineLearningFlowModelJobOutput"/>, <see cref="MachineLearningTableJobOutput"/>, <see cref="MachineLearningTritonModelJobOutput"/>, <see cref="MachineLearningUriFileJobOutput"/> and <see cref="MachineLearningUriFolderJobOutput"/>.
        /// </param>
        /// <param name="queueJobTier"> Queue settings for the job. </param>
        /// <returns> A new <see cref="Models.AutoMLJob"/> instance for mocking. </returns>
        public static AutoMLJob AutoMLJob(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, string displayName = null, MachineLearningJobStatus? status = null, string experimentName = null, IDictionary<string, MachineLearningJobService> services = null, ResourceIdentifier computeId = null, bool? isArchived = null, MachineLearningIdentityConfiguration identity = null, ResourceIdentifier componentId = null, NotificationSetting notificationSetting = null, MachineLearningJobResourceConfiguration resources = null, string environmentId = null, IDictionary<string, string> environmentVariables = null, AutoMLVertical taskDetails = null, IDictionary<string, MachineLearningJobOutput> outputs = null, JobTier? queueJobTier = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            services ??= new Dictionary<string, MachineLearningJobService>();
            environmentVariables ??= new Dictionary<string, string>();
            outputs ??= new Dictionary<string, MachineLearningJobOutput>();

            return new AutoMLJob(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                JobType.AutoML,
                displayName,
                status,
                experimentName,
                services,
                computeId,
                isArchived,
                identity,
                componentId,
                notificationSetting,
                resources,
                environmentId,
                environmentVariables,
                taskDetails,
                outputs,
                queueJobTier != null ? new JobQueueSettings(queueJobTier, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningAzureBlobDatastore"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isDefault"> Readonly property to indicate if datastore is the workspace default datastore. </param>
        /// <param name="credentials">
        /// [Required] Account credentials.
        /// Please note <see cref="MachineLearningDatastoreCredentials"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningAccountKeyDatastoreCredentials"/>, <see cref="MachineLearningCertificateDatastoreCredentials"/>, <see cref="MachineLearningNoneDatastoreCredentials"/>, <see cref="MachineLearningSasDatastoreCredentials"/> and <see cref="MachineLearningServicePrincipalDatastoreCredentials"/>.
        /// </param>
        /// <param name="accountName"> Storage account name. </param>
        /// <param name="containerName"> Storage account container name. </param>
        /// <param name="endpoint"> Azure cloud endpoint for the storage account. </param>
        /// <param name="protocol"> Protocol used to communicate with the storage account. </param>
        /// <param name="serviceDataAccessAuthIdentity"> Indicates which identity to use to authenticate service data access to customer's storage. </param>
        /// <param name="subscriptionId"> Azure Subscription Id. </param>
        /// <param name="resourceGroup"> Azure Resource Group name. </param>
        /// <returns> A new <see cref="Models.MachineLearningAzureBlobDatastore"/> instance for mocking. </returns>
        public static MachineLearningAzureBlobDatastore MachineLearningAzureBlobDatastore(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isDefault = null, MachineLearningDatastoreCredentials credentials = null, string accountName = null, string containerName = null, string endpoint = null, string protocol = null, MachineLearningServiceDataAccessAuthIdentity? serviceDataAccessAuthIdentity = null, string subscriptionId = null, string resourceGroup = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningAzureBlobDatastore(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                DatastoreType.AzureBlob,
                isDefault,
                credentials,
                accountName,
                containerName,
                endpoint,
                protocol,
                serviceDataAccessAuthIdentity,
                subscriptionId,
                resourceGroup);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningAzureDataLakeGen1Datastore"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isDefault"> Readonly property to indicate if datastore is the workspace default datastore. </param>
        /// <param name="credentials">
        /// [Required] Account credentials.
        /// Please note <see cref="MachineLearningDatastoreCredentials"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningAccountKeyDatastoreCredentials"/>, <see cref="MachineLearningCertificateDatastoreCredentials"/>, <see cref="MachineLearningNoneDatastoreCredentials"/>, <see cref="MachineLearningSasDatastoreCredentials"/> and <see cref="MachineLearningServicePrincipalDatastoreCredentials"/>.
        /// </param>
        /// <param name="storeName"> [Required] Azure Data Lake store name. </param>
        /// <param name="serviceDataAccessAuthIdentity"> Indicates which identity to use to authenticate service data access to customer's storage. </param>
        /// <param name="subscriptionId"> Azure Subscription Id. </param>
        /// <param name="resourceGroup"> Azure Resource Group name. </param>
        /// <returns> A new <see cref="Models.MachineLearningAzureDataLakeGen1Datastore"/> instance for mocking. </returns>
        public static MachineLearningAzureDataLakeGen1Datastore MachineLearningAzureDataLakeGen1Datastore(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isDefault = null, MachineLearningDatastoreCredentials credentials = null, string storeName = null, MachineLearningServiceDataAccessAuthIdentity? serviceDataAccessAuthIdentity = null, string subscriptionId = null, string resourceGroup = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningAzureDataLakeGen1Datastore(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                DatastoreType.AzureDataLakeGen1,
                isDefault,
                credentials,
                storeName,
                serviceDataAccessAuthIdentity,
                subscriptionId,
                resourceGroup);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningAzureDataLakeGen2Datastore"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isDefault"> Readonly property to indicate if datastore is the workspace default datastore. </param>
        /// <param name="credentials">
        /// [Required] Account credentials.
        /// Please note <see cref="MachineLearningDatastoreCredentials"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningAccountKeyDatastoreCredentials"/>, <see cref="MachineLearningCertificateDatastoreCredentials"/>, <see cref="MachineLearningNoneDatastoreCredentials"/>, <see cref="MachineLearningSasDatastoreCredentials"/> and <see cref="MachineLearningServicePrincipalDatastoreCredentials"/>.
        /// </param>
        /// <param name="filesystem"> [Required] The name of the Data Lake Gen2 filesystem. </param>
        /// <param name="accountName"> [Required] Storage account name. </param>
        /// <param name="endpoint"> Azure cloud endpoint for the storage account. </param>
        /// <param name="protocol"> Protocol used to communicate with the storage account. </param>
        /// <param name="serviceDataAccessAuthIdentity"> Indicates which identity to use to authenticate service data access to customer's storage. </param>
        /// <param name="subscriptionId"> Azure Subscription Id. </param>
        /// <param name="resourceGroup"> Azure Resource Group name. </param>
        /// <returns> A new <see cref="Models.MachineLearningAzureDataLakeGen2Datastore"/> instance for mocking. </returns>
        public static MachineLearningAzureDataLakeGen2Datastore MachineLearningAzureDataLakeGen2Datastore(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isDefault = null, MachineLearningDatastoreCredentials credentials = null, string filesystem = null, string accountName = null, string endpoint = null, string protocol = null, MachineLearningServiceDataAccessAuthIdentity? serviceDataAccessAuthIdentity = null, string subscriptionId = null, string resourceGroup = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningAzureDataLakeGen2Datastore(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                DatastoreType.AzureDataLakeGen2,
                isDefault,
                credentials,
                filesystem,
                accountName,
                endpoint,
                protocol,
                serviceDataAccessAuthIdentity,
                subscriptionId,
                resourceGroup);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningAzureFileDatastore"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isDefault"> Readonly property to indicate if datastore is the workspace default datastore. </param>
        /// <param name="credentials">
        /// [Required] Account credentials.
        /// Please note <see cref="MachineLearningDatastoreCredentials"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningAccountKeyDatastoreCredentials"/>, <see cref="MachineLearningCertificateDatastoreCredentials"/>, <see cref="MachineLearningNoneDatastoreCredentials"/>, <see cref="MachineLearningSasDatastoreCredentials"/> and <see cref="MachineLearningServicePrincipalDatastoreCredentials"/>.
        /// </param>
        /// <param name="accountName"> [Required] Storage account name. </param>
        /// <param name="fileShareName"> [Required] The name of the Azure file share that the datastore points to. </param>
        /// <param name="endpoint"> Azure cloud endpoint for the storage account. </param>
        /// <param name="protocol"> Protocol used to communicate with the storage account. </param>
        /// <param name="serviceDataAccessAuthIdentity"> Indicates which identity to use to authenticate service data access to customer's storage. </param>
        /// <param name="subscriptionId"> Azure Subscription Id. </param>
        /// <param name="resourceGroup"> Azure Resource Group name. </param>
        /// <returns> A new <see cref="Models.MachineLearningAzureFileDatastore"/> instance for mocking. </returns>
        public static MachineLearningAzureFileDatastore MachineLearningAzureFileDatastore(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isDefault = null, MachineLearningDatastoreCredentials credentials = null, string accountName = null, string fileShareName = null, string endpoint = null, string protocol = null, MachineLearningServiceDataAccessAuthIdentity? serviceDataAccessAuthIdentity = null, string subscriptionId = null, string resourceGroup = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new MachineLearningAzureFileDatastore(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                DatastoreType.AzureFile,
                isDefault,
                credentials,
                accountName,
                fileShareName,
                endpoint,
                protocol,
                serviceDataAccessAuthIdentity,
                subscriptionId,
                resourceGroup);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningCommandJob"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="displayName"> Display name of job. </param>
        /// <param name="status"> Status of the job. </param>
        /// <param name="experimentName"> The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment. </param>
        /// <param name="services">
        /// List of JobEndpoints.
        /// For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        /// </param>
        /// <param name="computeId"> ARM resource ID of the compute resource. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="identity">
        /// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        /// Defaults to AmlToken if null.
        /// Please note <see cref="MachineLearningIdentityConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmlToken"/>, <see cref="MachineLearningManagedIdentity"/> and <see cref="MachineLearningUserIdentity"/>.
        /// </param>
        /// <param name="componentId"> ARM resource ID of the component resource. </param>
        /// <param name="notificationSetting"> Notification setting for the job. </param>
        /// <param name="resources"> Compute Resource configuration for the job. </param>
        /// <param name="codeId"> ARM resource ID of the code asset. </param>
        /// <param name="command"> [Required] The command to execute on startup of the job. eg. "python train.py". </param>
        /// <param name="environmentId"> [Required] The ARM resource ID of the Environment specification for the job. </param>
        /// <param name="inputs">
        /// Mapping of input data bindings used in the job.
        /// Please note <see cref="MachineLearningJobInput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobInput"/>, <see cref="MachineLearningLiteralJobInput"/>, <see cref="MachineLearningFlowModelJobInput"/>, <see cref="MachineLearningTableJobInput"/>, <see cref="MachineLearningTritonModelJobInput"/>, <see cref="MachineLearningUriFileJobInput"/> and <see cref="MachineLearningUriFolderJobInput"/>.
        /// </param>
        /// <param name="outputs">
        /// Mapping of output data bindings used in the job.
        /// Please note <see cref="MachineLearningJobOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobOutput"/>, <see cref="MachineLearningFlowModelJobOutput"/>, <see cref="MachineLearningTableJobOutput"/>, <see cref="MachineLearningTritonModelJobOutput"/>, <see cref="MachineLearningUriFileJobOutput"/> and <see cref="MachineLearningUriFolderJobOutput"/>.
        /// </param>
        /// <param name="distribution">
        /// Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        /// Please note <see cref="MachineLearningDistributionConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MpiDistributionConfiguration"/>, <see cref="PyTorchDistributionConfiguration"/> and <see cref="TensorFlowDistributionConfiguration"/>.
        /// </param>
        /// <param name="limits"> Command Job limit. </param>
        /// <param name="environmentVariables"> Environment variables included in the job. </param>
        /// <param name="parameters"> Input parameters. </param>
        /// <param name="queueJobTier"> Queue settings for the job. </param>
        /// <returns> A new <see cref="Models.MachineLearningCommandJob"/> instance for mocking. </returns>
        public static MachineLearningCommandJob MachineLearningCommandJob(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, string displayName = null, MachineLearningJobStatus? status = null, string experimentName = null, IDictionary<string, MachineLearningJobService> services = null, ResourceIdentifier computeId = null, bool? isArchived = null, MachineLearningIdentityConfiguration identity = null, ResourceIdentifier componentId = null, NotificationSetting notificationSetting = null, MachineLearningJobResourceConfiguration resources = null, ResourceIdentifier codeId = null, string command = null, ResourceIdentifier environmentId = null, IDictionary<string, MachineLearningJobInput> inputs = null, IDictionary<string, MachineLearningJobOutput> outputs = null, MachineLearningDistributionConfiguration distribution = null, MachineLearningCommandJobLimits limits = null, IDictionary<string, string> environmentVariables = null, BinaryData parameters = null, JobTier? queueJobTier = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            services ??= new Dictionary<string, MachineLearningJobService>();
            inputs ??= new Dictionary<string, MachineLearningJobInput>();
            outputs ??= new Dictionary<string, MachineLearningJobOutput>();
            environmentVariables ??= new Dictionary<string, string>();

            return new MachineLearningCommandJob(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                JobType.Command,
                displayName,
                status,
                experimentName,
                services,
                computeId,
                isArchived,
                identity,
                componentId,
                notificationSetting,
                resources,
                codeId,
                command,
                environmentId,
                inputs,
                outputs,
                distribution,
                limits,
                environmentVariables,
                parameters,
                queueJobTier != null ? new JobQueueSettings(queueJobTier, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DockerCredential"/>. </summary>
        /// <param name="userName"> DockerCredential user name. </param>
        /// <param name="password"> DockerCredential user password. </param>
        /// <returns> A new <see cref="Models.DockerCredential"/> instance for mocking. </returns>
        public static DockerCredential DockerCredential(string userName = null, string password = null)
        {
            return new DockerCredential(DataReferenceCredentialType.DockerCredentials, serializedAdditionalRawData: null, userName, password);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningKubernetesOnlineDeployment"/>. </summary>
        /// <param name="description"> Description of the endpoint deployment. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="codeConfiguration"> Code configuration for the endpoint deployment. </param>
        /// <param name="environmentId"> ARM resource ID or AssetId of the environment specification for the endpoint deployment. </param>
        /// <param name="environmentVariables"> Environment variables configuration for the deployment. </param>
        /// <param name="scaleSettings">
        /// Scale settings for the deployment.
        /// If it is null or not provided,
        /// it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
        /// and to DefaultScaleSettings for ManagedOnlineDeployment.
        /// Please note <see cref="MachineLearningOnlineScaleSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningDefaultScaleSettings"/> and <see cref="MachineLearningTargetUtilizationScaleSettings"/>.
        /// </param>
        /// <param name="requestSettings"> Request settings for the deployment. </param>
        /// <param name="modelMountPath"> The path to mount the model in custom container. </param>
        /// <param name="appInsightsEnabled"> If true, enables Application Insights logging. </param>
        /// <param name="livenessProbe"> Liveness probe monitors the health of the container regularly. </param>
        /// <param name="readinessProbe"> Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe. </param>
        /// <param name="provisioningState"> Provisioning state for the endpoint deployment. </param>
        /// <param name="instanceType"> Compute instance type. </param>
        /// <param name="model"> The URI path to the model. </param>
        /// <param name="egressPublicNetworkAccess"> If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled. </param>
        /// <param name="dataCollector"> The mdc configuration, we disable mdc when it's null. </param>
        /// <param name="containerResourceRequirements"> The resource requirements for the container (cpu and memory). </param>
        /// <returns> A new <see cref="Models.MachineLearningKubernetesOnlineDeployment"/> instance for mocking. </returns>
        public static MachineLearningKubernetesOnlineDeployment MachineLearningKubernetesOnlineDeployment(string description = null, IDictionary<string, string> properties = null, MachineLearningCodeConfiguration codeConfiguration = null, string environmentId = null, IDictionary<string, string> environmentVariables = null, MachineLearningOnlineScaleSettings scaleSettings = null, MachineLearningOnlineRequestSettings requestSettings = null, string modelMountPath = null, bool? appInsightsEnabled = null, MachineLearningProbeSettings livenessProbe = null, MachineLearningProbeSettings readinessProbe = null, MachineLearningDeploymentProvisioningState? provisioningState = null, string instanceType = null, string model = null, MachineLearningEgressPublicNetworkAccessType? egressPublicNetworkAccess = null, DataCollector dataCollector = null, MachineLearningContainerResourceRequirements containerResourceRequirements = null)
        {
            properties ??= new Dictionary<string, string>();
            environmentVariables ??= new Dictionary<string, string>();

            return new MachineLearningKubernetesOnlineDeployment(
                description,
                properties,
                codeConfiguration,
                environmentId,
                environmentVariables,
                serializedAdditionalRawData: null,
                MachineLearningEndpointComputeType.Kubernetes,
                scaleSettings,
                requestSettings,
                modelMountPath,
                appInsightsEnabled,
                livenessProbe,
                readinessProbe,
                provisioningState,
                instanceType,
                model,
                egressPublicNetworkAccess,
                dataCollector,
                containerResourceRequirements);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedIdentityCredential"/>. </summary>
        /// <param name="managedIdentityType"> ManagedIdentityCredential identity type. </param>
        /// <param name="userManagedIdentityResourceId"> Full arm scope for the Id. For ManagedIdentityType = SystemManaged, this field is null. </param>
        /// <param name="userManagedIdentityClientId"> ClientId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </param>
        /// <param name="userManagedIdentityPrincipalId"> PrincipalId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </param>
        /// <param name="userManagedIdentityTenantId"> TenantId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </param>
        /// <returns> A new <see cref="Models.ManagedIdentityCredential"/> instance for mocking. </returns>
        public static ManagedIdentityCredential ManagedIdentityCredential(string managedIdentityType = null, string userManagedIdentityResourceId = null, string userManagedIdentityClientId = null, string userManagedIdentityPrincipalId = null, string userManagedIdentityTenantId = null)
        {
            return new ManagedIdentityCredential(
                DataReferenceCredentialType.ManagedIdentity,
                serializedAdditionalRawData: null,
                managedIdentityType,
                userManagedIdentityResourceId,
                userManagedIdentityClientId,
                userManagedIdentityPrincipalId,
                userManagedIdentityTenantId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningManagedOnlineDeployment"/>. </summary>
        /// <param name="description"> Description of the endpoint deployment. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="codeConfiguration"> Code configuration for the endpoint deployment. </param>
        /// <param name="environmentId"> ARM resource ID or AssetId of the environment specification for the endpoint deployment. </param>
        /// <param name="environmentVariables"> Environment variables configuration for the deployment. </param>
        /// <param name="scaleSettings">
        /// Scale settings for the deployment.
        /// If it is null or not provided,
        /// it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
        /// and to DefaultScaleSettings for ManagedOnlineDeployment.
        /// Please note <see cref="MachineLearningOnlineScaleSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningDefaultScaleSettings"/> and <see cref="MachineLearningTargetUtilizationScaleSettings"/>.
        /// </param>
        /// <param name="requestSettings"> Request settings for the deployment. </param>
        /// <param name="modelMountPath"> The path to mount the model in custom container. </param>
        /// <param name="appInsightsEnabled"> If true, enables Application Insights logging. </param>
        /// <param name="livenessProbe"> Liveness probe monitors the health of the container regularly. </param>
        /// <param name="readinessProbe"> Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe. </param>
        /// <param name="provisioningState"> Provisioning state for the endpoint deployment. </param>
        /// <param name="instanceType"> Compute instance type. </param>
        /// <param name="model"> The URI path to the model. </param>
        /// <param name="egressPublicNetworkAccess"> If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled. </param>
        /// <param name="dataCollector"> The mdc configuration, we disable mdc when it's null. </param>
        /// <returns> A new <see cref="Models.MachineLearningManagedOnlineDeployment"/> instance for mocking. </returns>
        public static MachineLearningManagedOnlineDeployment MachineLearningManagedOnlineDeployment(string description = null, IDictionary<string, string> properties = null, MachineLearningCodeConfiguration codeConfiguration = null, string environmentId = null, IDictionary<string, string> environmentVariables = null, MachineLearningOnlineScaleSettings scaleSettings = null, MachineLearningOnlineRequestSettings requestSettings = null, string modelMountPath = null, bool? appInsightsEnabled = null, MachineLearningProbeSettings livenessProbe = null, MachineLearningProbeSettings readinessProbe = null, MachineLearningDeploymentProvisioningState? provisioningState = null, string instanceType = null, string model = null, MachineLearningEgressPublicNetworkAccessType? egressPublicNetworkAccess = null, DataCollector dataCollector = null)
        {
            properties ??= new Dictionary<string, string>();
            environmentVariables ??= new Dictionary<string, string>();

            return new MachineLearningManagedOnlineDeployment(
                description,
                properties,
                codeConfiguration,
                environmentId,
                environmentVariables,
                serializedAdditionalRawData: null,
                MachineLearningEndpointComputeType.Managed,
                scaleSettings,
                requestSettings,
                modelMountPath,
                appInsightsEnabled,
                livenessProbe,
                readinessProbe,
                provisioningState,
                instanceType,
                model,
                egressPublicNetworkAccess,
                dataCollector);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OneLakeDatastore"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="isDefault"> Readonly property to indicate if datastore is the workspace default datastore. </param>
        /// <param name="credentials">
        /// [Required] Account credentials.
        /// Please note <see cref="MachineLearningDatastoreCredentials"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningAccountKeyDatastoreCredentials"/>, <see cref="MachineLearningCertificateDatastoreCredentials"/>, <see cref="MachineLearningNoneDatastoreCredentials"/>, <see cref="MachineLearningSasDatastoreCredentials"/> and <see cref="MachineLearningServicePrincipalDatastoreCredentials"/>.
        /// </param>
        /// <param name="artifact">
        /// [Required] OneLake artifact backing the datastore.
        /// Please note <see cref="OneLakeArtifact"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LakeHouseArtifact"/>.
        /// </param>
        /// <param name="oneLakeWorkspaceName"> [Required] OneLake workspace name. </param>
        /// <param name="endpoint"> OneLake endpoint to use for the datastore. </param>
        /// <param name="serviceDataAccessAuthIdentity"> Indicates which identity to use to authenticate service data access to customer's storage. </param>
        /// <returns> A new <see cref="Models.OneLakeDatastore"/> instance for mocking. </returns>
        public static OneLakeDatastore OneLakeDatastore(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, bool? isDefault = null, MachineLearningDatastoreCredentials credentials = null, OneLakeArtifact artifact = null, string oneLakeWorkspaceName = null, string endpoint = null, MachineLearningServiceDataAccessAuthIdentity? serviceDataAccessAuthIdentity = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new OneLakeDatastore(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                DatastoreType.OneLake,
                isDefault,
                credentials,
                artifact,
                oneLakeWorkspaceName,
                endpoint,
                serviceDataAccessAuthIdentity);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningPipelineJob"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="displayName"> Display name of job. </param>
        /// <param name="status"> Status of the job. </param>
        /// <param name="experimentName"> The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment. </param>
        /// <param name="services">
        /// List of JobEndpoints.
        /// For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        /// </param>
        /// <param name="computeId"> ARM resource ID of the compute resource. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="identity">
        /// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        /// Defaults to AmlToken if null.
        /// Please note <see cref="MachineLearningIdentityConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmlToken"/>, <see cref="MachineLearningManagedIdentity"/> and <see cref="MachineLearningUserIdentity"/>.
        /// </param>
        /// <param name="componentId"> ARM resource ID of the component resource. </param>
        /// <param name="notificationSetting"> Notification setting for the job. </param>
        /// <param name="settings"> Pipeline settings, for things like ContinueRunOnStepFailure etc. </param>
        /// <param name="jobs"> Jobs construct the Pipeline Job. </param>
        /// <param name="inputs">
        /// Inputs for the pipeline job.
        /// Please note <see cref="MachineLearningJobInput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobInput"/>, <see cref="MachineLearningLiteralJobInput"/>, <see cref="MachineLearningFlowModelJobInput"/>, <see cref="MachineLearningTableJobInput"/>, <see cref="MachineLearningTritonModelJobInput"/>, <see cref="MachineLearningUriFileJobInput"/> and <see cref="MachineLearningUriFolderJobInput"/>.
        /// </param>
        /// <param name="outputs">
        /// Outputs for the pipeline job
        /// Please note <see cref="MachineLearningJobOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobOutput"/>, <see cref="MachineLearningFlowModelJobOutput"/>, <see cref="MachineLearningTableJobOutput"/>, <see cref="MachineLearningTritonModelJobOutput"/>, <see cref="MachineLearningUriFileJobOutput"/> and <see cref="MachineLearningUriFolderJobOutput"/>.
        /// </param>
        /// <param name="sourceJobId"> ARM resource ID of source job. </param>
        /// <returns> A new <see cref="Models.MachineLearningPipelineJob"/> instance for mocking. </returns>
        public static MachineLearningPipelineJob MachineLearningPipelineJob(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, string displayName = null, MachineLearningJobStatus? status = null, string experimentName = null, IDictionary<string, MachineLearningJobService> services = null, ResourceIdentifier computeId = null, bool? isArchived = null, MachineLearningIdentityConfiguration identity = null, ResourceIdentifier componentId = null, NotificationSetting notificationSetting = null, BinaryData settings = null, IDictionary<string, BinaryData> jobs = null, IDictionary<string, MachineLearningJobInput> inputs = null, IDictionary<string, MachineLearningJobOutput> outputs = null, ResourceIdentifier sourceJobId = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            services ??= new Dictionary<string, MachineLearningJobService>();
            jobs ??= new Dictionary<string, BinaryData>();
            inputs ??= new Dictionary<string, MachineLearningJobInput>();
            outputs ??= new Dictionary<string, MachineLearningJobOutput>();

            return new MachineLearningPipelineJob(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                JobType.Pipeline,
                displayName,
                status,
                experimentName,
                services,
                computeId,
                isArchived,
                identity,
                componentId,
                notificationSetting,
                settings,
                jobs,
                inputs,
                outputs,
                sourceJobId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SasCredential"/>. </summary>
        /// <param name="sasUri"> Full SAS Uri, including the storage, container/blob path and SAS token. </param>
        /// <returns> A new <see cref="Models.SasCredential"/> instance for mocking. </returns>
        public static SasCredential SasCredential(Uri sasUri = null)
        {
            return new SasCredential(DataReferenceCredentialType.Sas, serializedAdditionalRawData: null, sasUri);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SasCredentialDto"/>. </summary>
        /// <param name="sasUri"> Full SAS Uri, including the storage, container/blob path and SAS token. </param>
        /// <returns> A new <see cref="Models.SasCredentialDto"/> instance for mocking. </returns>
        public static SasCredentialDto SasCredentialDto(Uri sasUri = null)
        {
            return new SasCredentialDto(PendingUploadCredentialType.Sas, serializedAdditionalRawData: null, sasUri);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkJob"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="displayName"> Display name of job. </param>
        /// <param name="status"> Status of the job. </param>
        /// <param name="experimentName"> The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment. </param>
        /// <param name="services">
        /// List of JobEndpoints.
        /// For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        /// </param>
        /// <param name="computeId"> ARM resource ID of the compute resource. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="identity">
        /// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        /// Defaults to AmlToken if null.
        /// Please note <see cref="MachineLearningIdentityConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmlToken"/>, <see cref="MachineLearningManagedIdentity"/> and <see cref="MachineLearningUserIdentity"/>.
        /// </param>
        /// <param name="componentId"> ARM resource ID of the component resource. </param>
        /// <param name="notificationSetting"> Notification setting for the job. </param>
        /// <param name="resources"> Compute Resource configuration for the job. </param>
        /// <param name="args"> Arguments for the job. </param>
        /// <param name="codeId"> [Required] arm-id of the code asset. </param>
        /// <param name="entry">
        /// [Required] The entry to execute on startup of the job.
        /// Please note <see cref="SparkJobEntry"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SparkJobPythonEntry"/> and <see cref="SparkJobScalaEntry"/>.
        /// </param>
        /// <param name="environmentId"> The ARM resource ID of the Environment specification for the job. </param>
        /// <param name="inputs">
        /// Mapping of input data bindings used in the job.
        /// Please note <see cref="MachineLearningJobInput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobInput"/>, <see cref="MachineLearningLiteralJobInput"/>, <see cref="MachineLearningFlowModelJobInput"/>, <see cref="MachineLearningTableJobInput"/>, <see cref="MachineLearningTritonModelJobInput"/>, <see cref="MachineLearningUriFileJobInput"/> and <see cref="MachineLearningUriFolderJobInput"/>.
        /// </param>
        /// <param name="outputs">
        /// Mapping of output data bindings used in the job.
        /// Please note <see cref="MachineLearningJobOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobOutput"/>, <see cref="MachineLearningFlowModelJobOutput"/>, <see cref="MachineLearningTableJobOutput"/>, <see cref="MachineLearningTritonModelJobOutput"/>, <see cref="MachineLearningUriFileJobOutput"/> and <see cref="MachineLearningUriFolderJobOutput"/>.
        /// </param>
        /// <param name="pyFiles"> Python files used in the job. </param>
        /// <param name="jars"> Jar files used in the job. </param>
        /// <param name="files"> Files used in the job. </param>
        /// <param name="archives"> Archive files used in the job. </param>
        /// <param name="conf"> Spark configured properties. </param>
        /// <param name="queueJobTier"> Queue settings for the job. </param>
        /// <param name="environmentVariables"> Environment variables included in the job. </param>
        /// <returns> A new <see cref="Models.SparkJob"/> instance for mocking. </returns>
        public static SparkJob SparkJob(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, string displayName = null, MachineLearningJobStatus? status = null, string experimentName = null, IDictionary<string, MachineLearningJobService> services = null, ResourceIdentifier computeId = null, bool? isArchived = null, MachineLearningIdentityConfiguration identity = null, ResourceIdentifier componentId = null, NotificationSetting notificationSetting = null, SparkResourceConfiguration resources = null, string args = null, ResourceIdentifier codeId = null, SparkJobEntry entry = null, ResourceIdentifier environmentId = null, IDictionary<string, MachineLearningJobInput> inputs = null, IDictionary<string, MachineLearningJobOutput> outputs = null, IEnumerable<string> pyFiles = null, IEnumerable<string> jars = null, IEnumerable<string> files = null, IEnumerable<string> archives = null, IDictionary<string, string> conf = null, JobTier? queueJobTier = null, IDictionary<string, string> environmentVariables = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            services ??= new Dictionary<string, MachineLearningJobService>();
            inputs ??= new Dictionary<string, MachineLearningJobInput>();
            outputs ??= new Dictionary<string, MachineLearningJobOutput>();
            pyFiles ??= new List<string>();
            jars ??= new List<string>();
            files ??= new List<string>();
            archives ??= new List<string>();
            conf ??= new Dictionary<string, string>();
            environmentVariables ??= new Dictionary<string, string>();

            return new SparkJob(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                JobType.Spark,
                displayName,
                status,
                experimentName,
                services,
                computeId,
                isArchived,
                identity,
                componentId,
                notificationSetting,
                resources,
                args,
                codeId,
                entry,
                environmentId,
                inputs,
                outputs,
                pyFiles?.ToList(),
                jars?.ToList(),
                files?.ToList(),
                archives?.ToList(),
                conf,
                queueJobTier != null ? new JobQueueSettings(queueJobTier, serializedAdditionalRawData: null) : null,
                environmentVariables);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineLearningSweepJob"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="displayName"> Display name of job. </param>
        /// <param name="status"> Status of the job. </param>
        /// <param name="experimentName"> The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment. </param>
        /// <param name="services">
        /// List of JobEndpoints.
        /// For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        /// </param>
        /// <param name="computeId"> ARM resource ID of the compute resource. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="identity">
        /// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        /// Defaults to AmlToken if null.
        /// Please note <see cref="MachineLearningIdentityConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmlToken"/>, <see cref="MachineLearningManagedIdentity"/> and <see cref="MachineLearningUserIdentity"/>.
        /// </param>
        /// <param name="componentId"> ARM resource ID of the component resource. </param>
        /// <param name="notificationSetting"> Notification setting for the job. </param>
        /// <param name="searchSpace"> [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter. </param>
        /// <param name="samplingAlgorithm">
        /// [Required] The hyperparameter sampling algorithm
        /// Please note <see cref="SamplingAlgorithm"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BayesianSamplingAlgorithm"/>, <see cref="GridSamplingAlgorithm"/> and <see cref="RandomSamplingAlgorithm"/>.
        /// </param>
        /// <param name="limits"> Sweep Job limit. </param>
        /// <param name="earlyTermination">
        /// Early termination policies enable canceling poor-performing runs before they complete
        /// Please note <see cref="MachineLearningEarlyTerminationPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BanditPolicy"/>, <see cref="MedianStoppingPolicy"/> and <see cref="TruncationSelectionPolicy"/>.
        /// </param>
        /// <param name="objective"> [Required] Optimization objective. </param>
        /// <param name="trial"> [Required] Trial component definition. </param>
        /// <param name="inputs">
        /// Mapping of input data bindings used in the job.
        /// Please note <see cref="MachineLearningJobInput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobInput"/>, <see cref="MachineLearningLiteralJobInput"/>, <see cref="MachineLearningFlowModelJobInput"/>, <see cref="MachineLearningTableJobInput"/>, <see cref="MachineLearningTritonModelJobInput"/>, <see cref="MachineLearningUriFileJobInput"/> and <see cref="MachineLearningUriFolderJobInput"/>.
        /// </param>
        /// <param name="outputs">
        /// Mapping of output data bindings used in the job.
        /// Please note <see cref="MachineLearningJobOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MachineLearningCustomModelJobOutput"/>, <see cref="MachineLearningFlowModelJobOutput"/>, <see cref="MachineLearningTableJobOutput"/>, <see cref="MachineLearningTritonModelJobOutput"/>, <see cref="MachineLearningUriFileJobOutput"/> and <see cref="MachineLearningUriFolderJobOutput"/>.
        /// </param>
        /// <param name="queueJobTier"> Queue settings for the job. </param>
        /// <returns> A new <see cref="Models.MachineLearningSweepJob"/> instance for mocking. </returns>
        public static MachineLearningSweepJob MachineLearningSweepJob(string description = null, IDictionary<string, string> tags = null, IDictionary<string, string> properties = null, string displayName = null, MachineLearningJobStatus? status = null, string experimentName = null, IDictionary<string, MachineLearningJobService> services = null, ResourceIdentifier computeId = null, bool? isArchived = null, MachineLearningIdentityConfiguration identity = null, ResourceIdentifier componentId = null, NotificationSetting notificationSetting = null, BinaryData searchSpace = null, SamplingAlgorithm samplingAlgorithm = null, MachineLearningSweepJobLimits limits = null, MachineLearningEarlyTerminationPolicy earlyTermination = null, MachineLearningObjective objective = null, MachineLearningTrialComponent trial = null, IDictionary<string, MachineLearningJobInput> inputs = null, IDictionary<string, MachineLearningJobOutput> outputs = null, JobTier? queueJobTier = null)
        {
            tags ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();
            services ??= new Dictionary<string, MachineLearningJobService>();
            inputs ??= new Dictionary<string, MachineLearningJobInput>();
            outputs ??= new Dictionary<string, MachineLearningJobOutput>();

            return new MachineLearningSweepJob(
                description,
                tags,
                properties,
                serializedAdditionalRawData: null,
                JobType.Sweep,
                displayName,
                status,
                experimentName,
                services,
                computeId,
                isArchived,
                identity,
                componentId,
                notificationSetting,
                searchSpace,
                samplingAlgorithm,
                limits,
                earlyTermination,
                objective,
                trial,
                inputs,
                outputs,
                queueJobTier != null ? new JobQueueSettings(queueJobTier, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TextClassificationMultilabel"/>. </summary>
        /// <param name="logVerbosity"> Log verbosity for the job. </param>
        /// <param name="trainingData"> [Required] Training data input. </param>
        /// <param name="targetColumnName">
        /// Target column name: This is prediction values column.
        /// Also known as label column name in context of classification tasks.
        /// </param>
        /// <param name="primaryMetric">
        /// Primary metric for Text-Classification-Multilabel task.
        /// Currently only Accuracy is supported as primary metric, hence user need not set it explicitly.
        /// </param>
        /// <param name="limitSettings"> Execution constraints for AutoMLJob. </param>
        /// <param name="featurizationDatasetLanguage"> Featurization inputs needed for AutoML job. </param>
        /// <param name="validationData"> Validation data inputs. </param>
        /// <returns> A new <see cref="Models.TextClassificationMultilabel"/> instance for mocking. </returns>
        public static TextClassificationMultilabel TextClassificationMultilabel(MachineLearningLogVerbosity? logVerbosity = null, MachineLearningTableJobInput trainingData = null, string targetColumnName = null, ClassificationMultilabelPrimaryMetric? primaryMetric = null, NlpVerticalLimitSettings limitSettings = null, string featurizationDatasetLanguage = null, MachineLearningTableJobInput validationData = null)
        {
            return new TextClassificationMultilabel(
                TaskType.TextClassificationMultilabel,
                logVerbosity,
                trainingData,
                targetColumnName,
                serializedAdditionalRawData: null,
                primaryMetric,
                limitSettings,
                featurizationDatasetLanguage != null ? new NlpVerticalFeaturizationSettings(featurizationDatasetLanguage, serializedAdditionalRawData: null) : null,
                validationData);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TextNer"/>. </summary>
        /// <param name="logVerbosity"> Log verbosity for the job. </param>
        /// <param name="trainingData"> [Required] Training data input. </param>
        /// <param name="targetColumnName">
        /// Target column name: This is prediction values column.
        /// Also known as label column name in context of classification tasks.
        /// </param>
        /// <param name="primaryMetric">
        /// Primary metric for Text-NER task.
        /// Only 'Accuracy' is supported for Text-NER, so user need not set this explicitly.
        /// </param>
        /// <param name="limitSettings"> Execution constraints for AutoMLJob. </param>
        /// <param name="featurizationDatasetLanguage"> Featurization inputs needed for AutoML job. </param>
        /// <param name="validationData"> Validation data inputs. </param>
        /// <returns> A new <see cref="Models.TextNer"/> instance for mocking. </returns>
        public static TextNer TextNer(MachineLearningLogVerbosity? logVerbosity = null, MachineLearningTableJobInput trainingData = null, string targetColumnName = null, ClassificationPrimaryMetric? primaryMetric = null, NlpVerticalLimitSettings limitSettings = null, string featurizationDatasetLanguage = null, MachineLearningTableJobInput validationData = null)
        {
            return new TextNer(
                TaskType.TextNER,
                logVerbosity,
                trainingData,
                targetColumnName,
                serializedAdditionalRawData: null,
                primaryMetric,
                limitSettings,
                featurizationDatasetLanguage != null ? new NlpVerticalFeaturizationSettings(featurizationDatasetLanguage, serializedAdditionalRawData: null) : null,
                validationData);
        }
    }
}
