// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.MachineLearningCompute.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MachineLearningCompute
{
    public partial class OperationalizationClusterData : IUtf8JsonSerializable, IJsonModel<OperationalizationClusterData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OperationalizationClusterData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OperationalizationClusterData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalizationClusterData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OperationalizationClusterData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("createdOn"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ModifiedOn))
            {
                writer.WritePropertyName("modifiedOn"u8);
                writer.WriteStringValue(ModifiedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ProvisioningErrors))
            {
                writer.WritePropertyName("provisioningErrors"u8);
                writer.WriteStartArray();
                foreach (var item in ProvisioningErrors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ClusterType))
            {
                writer.WritePropertyName("clusterType"u8);
                writer.WriteStringValue(ClusterType.Value.ToString());
            }
            if (Optional.IsDefined(StorageAccount))
            {
                writer.WritePropertyName("storageAccount"u8);
                writer.WriteObjectValue(StorageAccount, options);
            }
            if (Optional.IsDefined(ContainerRegistry))
            {
                writer.WritePropertyName("containerRegistry"u8);
                writer.WriteObjectValue(ContainerRegistry, options);
            }
            if (Optional.IsDefined(ContainerService))
            {
                writer.WritePropertyName("containerService"u8);
                writer.WriteObjectValue(ContainerService, options);
            }
            if (Optional.IsDefined(AppInsights))
            {
                writer.WritePropertyName("appInsights"u8);
                writer.WriteObjectValue(AppInsights, options);
            }
            if (Optional.IsDefined(GlobalServiceConfiguration))
            {
                writer.WritePropertyName("globalServiceConfiguration"u8);
                writer.WriteObjectValue(GlobalServiceConfiguration, options);
            }
            writer.WriteEndObject();
        }

        OperationalizationClusterData IJsonModel<OperationalizationClusterData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalizationClusterData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OperationalizationClusterData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOperationalizationClusterData(document.RootElement, options);
        }

        internal static OperationalizationClusterData DeserializeOperationalizationClusterData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string description = default;
            DateTimeOffset? createdOn = default;
            DateTimeOffset? modifiedOn = default;
            OperationStatus? provisioningState = default;
            IReadOnlyList<ErrorResponseWrapper> provisioningErrors = default;
            ClusterType? clusterType = default;
            StorageAccountProperties storageAccount = default;
            ContainerRegistryProperties containerRegistry = default;
            AcsClusterProperties containerService = default;
            AppInsightsProperties appInsights = default;
            GlobalServiceConfiguration globalServiceConfiguration = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("createdOn"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            createdOn = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("modifiedOn"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            modifiedOn = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new OperationStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningErrors"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ErrorResponseWrapper> array = new List<ErrorResponseWrapper>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ErrorResponseWrapper.DeserializeErrorResponseWrapper(item, options));
                            }
                            provisioningErrors = array;
                            continue;
                        }
                        if (property0.NameEquals("clusterType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterType = new ClusterType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("storageAccount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            storageAccount = StorageAccountProperties.DeserializeStorageAccountProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("containerRegistry"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            containerRegistry = ContainerRegistryProperties.DeserializeContainerRegistryProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("containerService"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            containerService = AcsClusterProperties.DeserializeAcsClusterProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("appInsights"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            appInsights = AppInsightsProperties.DeserializeAppInsightsProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("globalServiceConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            globalServiceConfiguration = GlobalServiceConfiguration.DeserializeGlobalServiceConfiguration(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OperationalizationClusterData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                description,
                createdOn,
                modifiedOn,
                provisioningState,
                provisioningErrors ?? new ChangeTrackingList<ErrorResponseWrapper>(),
                clusterType,
                storageAccount,
                containerRegistry,
                containerService,
                appInsights,
                globalServiceConfiguration,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OperationalizationClusterData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalizationClusterData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OperationalizationClusterData)} does not support writing '{options.Format}' format.");
            }
        }

        OperationalizationClusterData IPersistableModel<OperationalizationClusterData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalizationClusterData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOperationalizationClusterData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OperationalizationClusterData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OperationalizationClusterData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
